<?php $__env->startSection('title', isset($title) ? $title : ''); ?>
<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- breadcrumb -->
    <div class="custom-breadcrumb">
        <div class="row">
            <div class="col-12">
                <ul>
                    <li><?php echo e(__('Wallet Management')); ?></li>
                    <li class="active-item"><?php echo e(__('Send coin to user')); ?></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- /breadcrumb -->

    <!-- User Management -->
    <div class="user-management pt-4">
        <div class="row">
            <div class="col-12">
                <div class="profile-info-form">
                    <form action="<?php echo e(route('adminSendBalanceProcess')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-md-12 mt-20">
                                <div class="form-group row">
                                    <div class="col-md-4">
                                        <label><?php echo e(__('Amount')); ?></label>
                                        <input type="text" name="amount" class="form-control h-50" value="<?php echo e(old('amount')); ?>">
                                    </div>
                                    <div class="col-md-4">
                                        <label><?php echo e(__('Select User Wallet')); ?></label>
                                        <div class="customSelect rounded">
                                            <select name="wallet_id[]" id="user_select" class="selectpicker bg-dark w-100" title="<?php echo e(__('User Wallet')); ?>" data-live-search="true" data-actions-box="true" data-selected-text-format="count > 4" multiple>
                                                <?php if(isset($wallets[0])): ?>
                                                    <?php $__currentLoopData = $wallets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option class="" value="<?php echo e($user->id); ?>"><?php echo e($user->name. ' ('. $user->email .')'); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group row">
                                    <div class="col-6">
                                        <button type="submit" class="button-primary theme-btn"><?php echo e(__('Send')); ?></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- /User Management -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        (function($) {
            "use strict";

        })(jQuery)
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master',['menu'=>'wallet'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/tradexpro-admin/resources/views/admin/wallet/send_wallet_coin.blade.php ENDPATH**/ ?>