<?php $__env->startSection('title', isset($title) ? $title : ''); ?>
<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- breadcrumb -->
    <div class="custom-breadcrumb">
        <div class="row">
            <div class="col-12">
                <ul>
                    <li><?php echo e(__('Fiat Deposit')); ?> </li>
                    <li class="active-item"><?php echo e(__('Deposit History')); ?></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- /breadcrumb -->
    <!-- User Management -->
    <div class="user-management wallet-transaction-area">
        <div class="row no-gutters">
            <div class="col-12 col-lg-2">
                <ul class="nav wallet-transaction user-management-nav mb-3" id="pills-tab" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" id="pills-deposit-tab" data-toggle="pill" href="#pills-deposit"
                            role="tab" aria-controls="pills-deposit" aria-selected="true">
                            <?php echo e(__('Pending Deposit List')); ?>

                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="pills-withdraw-tab" data-toggle="pill" href="#pills-withdraw"
                            role="tab" aria-controls="pills-withdraw" aria-selected="true">
                            <?php echo e(__('Rejected Deposit List')); ?>

                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="pills-success-withdraw-tab" data-toggle="pill"
                            href="#pills-success-withdraw" role="tab" aria-controls="pills-success-withdraw"
                            aria-selected="true">
                            <?php echo e(__('Active Deposit List')); ?>

                        </a>
                    </li>
                </ul>
            </div>
            <div class="col-12 col-lg-10">
                <div class="tab-content" id="pills-tabContent">
                    <div class="tab-pane fade show active" id="pills-deposit" role="tabpanel"
                            aria-labelledby="pills-deposit-tab">
                        <div class="table-area">
                            <div class="table-responsive">
                                <table id="table-pending" class="table table-borderless custom-table display text-left"
                                        width="100%">
                                    <thead>
                                    <tr>
                                        <th class="all"><?php echo e(__('User Name')); ?></th>
                                        <th><?php echo e(__('Bank')); ?></th>
                                        <th><?php echo e(__('Payment Method')); ?></th>
                                        <th><?php echo e(__('Currency Amount')); ?></th>
                                        <th><?php echo e(__('Coin Amount')); ?></th>
                                        <th><?php echo e(__('Rate')); ?></th>
                                        <th class="all"><?php echo e(__('Bank Receipt')); ?> </th>
                                        <th><?php echo e(__('Date')); ?> </th>
                                        <th class="all"><?php echo e(__('Actions')); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="pills-withdraw" role="tabpanel"
                            aria-labelledby="pills-withdraw-tab">
                        <div class="table-area">
                            <div class="table-responsive">
                                <table id="reject-withdrawal"
                                        class="table table-borderless custom-table display text-left" width="100%">
                                    <thead>
                                    <tr>
                                        <th class="all"><?php echo e(__('User Name')); ?></th>
                                        <th><?php echo e(__('Wallet')); ?></th>
                                        <th><?php echo e(__('Bank')); ?></th>
                                        <th><?php echo e(__('Payment Method')); ?></th>
                                        <th><?php echo e(__('Currency')); ?></th>
                                        <th><?php echo e(__('Currency Amount')); ?></th>
                                        <th><?php echo e(__('Coin Amount')); ?></th>
                                        <th><?php echo e(__('Rate')); ?></th>
                                        <th class="all"><?php echo e(__('Bank Receipt')); ?> </th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="pills-success-withdraw" role="tabpanel"
                            aria-labelledby="pills-success-withdraw-tab">
                        <div class="table-area">
                            <div class="table-responsive">
                                <table id="success-withdrawal"
                                        class="table table-borderless custom-table display text-left" width="100%">
                                    <thead>
                                    <tr>
                                        <th class="all"><?php echo e(__('User Name')); ?></th>
                                        <th><?php echo e(__('Wallet')); ?></th>
                                        <th><?php echo e(__('Bank')); ?></th>
                                        <th><?php echo e(__('Payment Method')); ?></th>
                                        <th><?php echo e(__('Currency')); ?></th>
                                        <th><?php echo e(__('Currency Amount')); ?></th>
                                        <th><?php echo e(__('Coin Amount')); ?></th>
                                        <th><?php echo e(__('Rate')); ?></th>
                                        <th class="all"><?php echo e(__('Bank Receipt')); ?> </th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /User Management -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        (function($) {
            "use strict";

            $('#table-pending').DataTable({
                processing: true,
                serverSide: true,
                pageLength: 25,
                responsive: true,
                ajax: '<?php echo e(route('currencyDepositPendingList')); ?>',
                order: [7, 'desc'],
                autoWidth: false,
                language: {
                    paginate: {
                        next: 'Next &#8250;',
                        previous: '&#8249; Previous'
                    }
                },
                columns: [
                    {"data": "user"},
                    {"data": "bank"},
                    {"data": "payment_method"},
                    {"data": "currency_amount"},
                    {"data": "coin_amount"},
                    {"data": "rate"},
                    {"data": "bank_receipt"},
                    {"data": "created_at"},
                    {"data": "actions"}
                ]
            });


            $('#reject-withdrawal').DataTable({
                processing: true,
                serverSide: true,
                pageLength: 25,
                responsive: true,
                ajax: '<?php echo e(route('currencyDepositRejectList')); ?>',
                order: [8, 'desc'],
                autoWidth: false,
                language: {
                    paginate: {
                        next: 'Next &#8250;',
                        previous: '&#8249; Previous'
                    }
                },
                columns: [
                    {"data": "user"},
                    {"data": "to_wallet"},
                    {"data": "bank"},
                    {"data": "payment_method"},
                    {"data": "currency"},
                    {"data": "currency_amount"},
                    {"data": "coin_amount"},
                    {"data": "rate"},
                    {"data": "bank_receipt"}
                ]
            });


            $('#success-withdrawal').DataTable({
                processing: true,
                serverSide: true,
                pageLength: 25,
                responsive: true,
                ajax: '<?php echo e(route('currencyDepositAcceptList')); ?>',
                order: [8, 'desc'],
                autoWidth: false,
                language: {
                    paginate: {
                        next: 'Next &#8250;',
                        previous: '&#8249; Previous'
                    }
                },
                columns: [
                    {"data": "user"},
                    {"data": "to_wallet"},
                    {"data": "bank"},
                    {"data": "payment_method"},
                    {"data": "currency"},
                    {"data": "currency_amount"},
                    {"data": "coin_amount"},
                    {"data": "rate"},
                    {"data": "bank_receipt"}
                ]
            });
        })(jQuery);
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master',['menu'=>'currency_deposit', 'sub_menu'=>'pending_deposite_list'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/tradexpro-admin/resources/views/admin/currency-deposite/pending-deposite-list.blade.php ENDPATH**/ ?>