<?php $__env->startSection('title', isset($title) ? $title : ''); ?>
<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- breadcrumb -->
    <div class="custom-breadcrumb">
        <div class="row">
            <div class="col-md-9">
                <ul>
                    <li><?php echo e(__('Coin')); ?></li>
                    <li class="active-item"><?php echo e($title); ?></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- /breadcrumb -->

    <!-- User Management -->
    <div class="user-management">
        <div class="row">
            <div class="col-12">
                <?php if($item->network == BITGO_API): ?>
                <div class="header-bar">
                    <div class="table-title">

                    </div>
                    <div class="right d-flex align-items-center">
                        <div class="add-btn-new mb-2">
                            <a href="<?php echo e(route('adminCoinApiSettings',['tab' => 'bitgo'])); ?>"><?php echo e(__('Bitgo Api Setting')); ?></a>
                        </div>
                        <div class="add-btn-new mb-2 ml-2">
                            <a href="<?php echo e(route('adminAdjustBitgoWallet',encrypt($item->coin_id))); ?>"><?php echo e(__('Adjust Bitgo Wallet')); ?></a>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <?php if($item->network == ERC20_TOKEN || $item->network == BEP20_TOKEN): ?>
                <div class="header-bar">
                    <div class="table-title">

                    </div>
                    <div class="right d-flex align-items-center">
                        <div class="add-btn-new mb-2">
                            <a href="<?php echo e(route('adminCoinApiSettings',['tab' => 'erc20'])); ?>"><?php echo e(__('Token Api Setting')); ?></a>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <div class="profile-info-form">
                    <div>
                        <?php echo e(Form::open(['route'=>'adminSaveCoinSetting', 'files' => true])); ?>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <div class="controls">
                                        <div class="form-label"><?php echo e(__('Coin Type')); ?></div>
                                        <p class="form-control"><?php echo e($item->coin_type); ?></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <div class="controls">
                                        <div class="form-label"><?php echo e(__('Coin API')); ?></div>
                                        <p class="form-control"><?php echo e(api_settings($item->network)); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php if($item->network == BITCOIN_API): ?>
                            <?php echo $__env->make('admin.coin-order.include.bitcoin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php elseif($item->network == BITGO_API): ?>
                            <?php echo $__env->make('admin.coin-order.include.bitgo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php else: ?>
                            <?php echo $__env->make('admin.coin-order.include.erc20', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>
                        <div class="row">
                            <div class="col-md-2">
                                <?php if(isset($item)): ?><input type="hidden" name="coin_id" value="<?php echo e(encrypt($item->coin_id)); ?>">  <?php endif; ?>
                                <button type="submit" class="btn theme-btn"><?php echo e($button_title); ?></button>
                            </div>
                        </div>
                        <?php echo e(Form::close()); ?>

                        <?php if($item->network == BITGO_API): ?>
                            <hr>
                            <div class="custom-breadcrumb">
                                <div class="row">
                                    <div class="col-9">
                                        <ul>
                                            <li class="active-item"><?php echo e(__("Add Bitgo Webhook")); ?></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <?php echo e(Form::open(['route'=>'webhookSave', 'files' => true])); ?>

                            <?php echo $__env->make('admin.coin-order.include.webhook', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <div class="row">
                                <div class="col-md-2">
                                    <?php if(isset($item)): ?><input type="hidden" name="coin_id" value="<?php echo e(encrypt($item->coin_id)); ?>">  <?php endif; ?>
                                    <button type="submit" class="btn theme-btn"><?php echo e(__("Update Webhook")); ?></button>
                                </div>
                            </div>
                            <?php echo e(Form::close()); ?>

                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php if($item->network == ERC20_TOKEN || $item->network == BEP20_TOKEN): ?>
                <div class="col-md-12">
                    <div class="row float-right">
                        <div class="col-md-12">
                            <a href="javascript:" class="btn theme-btn float-right" onclick="check_wallet_address()"><?php echo e(__('Check Wallet Address')); ?></a>
                        </div>
                        <div class="col-md-12">
                            <h3 class="text-danger mt-2 float-right" id="check_wallet_address_message"></h3>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <!-- /User Management -->

    <div id="update_wallet" class="modal fade delete" role="dialog">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <h6 class="modal-title">
                        <?php echo e(__('Update Wallet Key')); ?>

                    </h6>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <form action="<?php echo e(route('updateWalletKey')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row">
                            <input type="hidden" name="id" value="<?php echo e(encrypt($item->id)); ?>">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="#"><?php echo e(__('Wallet Key')); ?></label>
                                    <input type="text" name="wallet_key" class="form-control">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-default" data-dismiss="modal">
                            <?php echo e(__("Cancel")); ?>

                        </button>
                        <button type="submit" class="btn theme-btn">
                            <?php echo e(__('Submit')); ?> 
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div id="viewWalletKey" class="modal fade delete" role="dialog">
        <div class="modal-dialog modal-md">
            <div class="modal-content">
                <div class="modal-header">
                    <h6 class="modal-title">
                        <?php echo e(__('View Wallet Key')); ?>

                    </h6>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <form id="view_wallet_key_submit_form">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row">
                            <input type="hidden" name="id" value="<?php echo e(encrypt($item->id)); ?>">
                            <div class="col-md-12" id="user_password_input_details">
                                <div class="form-group">
                                    <label for="#"><?php echo e(__('Enter Your Password')); ?></label>
                                    <input id="view_wallet_key_user_password" type="password" name="password" class="form-control">
                                </div>
                            </div>
                            <div id="view_details_wallet_key" class="col-md-12 d-none">
                                
                                    <div class="form-group">
                                        <div class="d-flex justify-content-between">
                                        <label for="#"><?php echo e(__('Wallet Key')); ?></label>
                                        <a class="btn btn-sm btn-success" id="copy_wallet_key">
                                            <?php echo e(__('Copy')); ?>

                                        </a>
                                    </div>
                                        <input type="text" id="wallet_key_view" class="form-control" value="">
                                    </div>
                                
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-default" data-dismiss="modal">
                            <?php echo e(__("Cancel")); ?>

                        </button>
                        <button type="submit" class="btn theme-btn">
                            <?php echo e(__('Confirm')); ?> 
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
    $('.view-wallet-key').click(function(){
        $('#view_details_wallet_key').addClass('d-none');
        $('#user_password_input_details').removeClass('d-none');
    });

    $('#copy_wallet_key').click(function() {
        var textToCopy = $('#wallet_key_view').val();
        console.log(textToCopy);
        var tempTextarea = $('<textarea>');
        $('body').append(tempTextarea);
        tempTextarea.val(textToCopy).select();
        document.execCommand('copy');
        tempTextarea.remove();
    });

    function check_wallet_address()
    {
        var wallet_key = $('#wallet_key').val();
        
        if(wallet_key !== '')
        {
            $.ajax({
                type: "POST",
                url: "<?php echo e(route('check_wallet_address')); ?>",
                data: {
                    '_token': "<?php echo e(csrf_token()); ?>",
                    'wallet_key': wallet_key,
                    'coin_type': '<?php echo e($item->coin_type); ?>'
                },
                success: function (data) {
                    $('#check_wallet_address_message').empty().text(data.message);
                }
            });

            
        }else{
            $('#check_wallet_address_message').empty().text('<?php echo e(__('please, Insert wallet key First')); ?>');
        }
        
    }

    $('#view_wallet_key_submit_form').submit(function(event) {
        event.preventDefault(); // Prevent default form submission

        var formData = $(this).serialize(); // Serialize form data

        $.ajax({
            url: "<?php echo e(route('viewWalletKey')); ?>", // URL to submit the form
            type: "POST",
            data: formData, // Form data
            dataType: "json", // Response type
            success: function(response) {
                // Handle success response
                console.log(response);
                if(response.success == true)
                {
                    VanillaToasts.create({
                        text: response.message,
                        backgroundColor: "linear-gradient(135deg, #73a5ff, #5477f5)",
                        type: 'success',
                        timeout: 40000
                    });

                    $('#view_details_wallet_key').removeClass('d-none');
                    $('#user_password_input_details').addClass('d-none');
                    $('#wallet_key_view').val(response.data);
                    $('#view_wallet_key_user_password').val('');
                }else{
                    VanillaToasts.create({
                        text: response.message,
                        type: 'warning',
                        timeout: 40000
                    });
                    console.log('else');
                }
            },
            error: function(xhr, status, error) {
                // Handle error response
                console.log(error);
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master',['menu'=>'coin', 'sub_menu' => 'coin_list'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/tradexpro-admin/resources/views/admin/coin-order/edit_coin_settings.blade.php ENDPATH**/ ?>