<div class="header-bar">
    <div class="table-title">
        <h3><?php echo e(__('Update Live Chat api')); ?></h3>
    </div>
</div>
<div class="profile-info-form">
    <form action="<?php echo e(route('adminCookieSettingsSave')); ?>" method="post"
          enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="row">
            <div class="col-lg-6 col-12 mt-20">
                <div class="form-group">
                    <label><?php echo e(__('Enable live chat')); ?></label>
                    <div class="cp-select-area">
                        <select name="live_chat_status" class="form-control">
                            <option <?php if(isset($settings['live_chat_status']) && $settings['live_chat_status'] == STATUS_REJECTED): ?> selected <?php endif; ?> value="<?php echo e(STATUS_REJECTED); ?>"><?php echo e(__("No")); ?></option>
                            <option <?php if(isset($settings['live_chat_status']) && $settings['live_chat_status'] == STATUS_ACTIVE): ?> selected <?php endif; ?> value="<?php echo e(STATUS_ACTIVE); ?>"><?php echo e(__("Yes")); ?></option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 col-12 mt-20">
                <div class="form-group">
                    <label
                        for="#"><?php echo e(__('Chat api key')); ?> </label>
                    <?php if(env('APP_MODE') == 'demo'): ?>
                        <input class="form-control" value="<?php echo e('disablefordemo'); ?>">
                    <?php else: ?>
                    <input class="form-control " type="text"
                           name="live_chat_key" placeholder=""
                           value="<?php echo e(isset($settings['live_chat_key']) ? $settings['live_chat_key'] : ''); ?>">
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-2 col-12 mt-20">
                <button class="button-primary theme-btn"><?php echo e(__('Update')); ?></button>
            </div>
        </div>
    </form>
</div>
<?php /**PATH /var/www/html/tradexpro-admin/resources/views/admin/settings/feature/chat_api_setting.blade.php ENDPATH**/ ?>