<?php $__env->startSection('title', isset($title) ? $title : ''); ?>
<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- breadcrumb -->
    <div class="custom-breadcrumb">
        <div class="row">
            <div class="col-md-9">
                <ul>
                    <li class="active-item"><?php echo e($title); ?></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- /breadcrumb -->
    <div class="user-management">
        <div class="row">
            <div class="col-12">
                <div class="profile-info-form">
                    <div>
                        <form action="<?php echo e(route('coinPairFutureSettingUpdate')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="id" value="<?php echo e(encrypt($coin_pair_details->id)); ?>">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <div class="controls">
                                            <div class="form-label"><?php echo e(__('Trade Coin')); ?></div>
                                            <input type="text" class="form-control" 
                                                value="<?php echo e(isset($coin_pair_details->child_coin) ? check_default_coin_type($coin_pair_details->child_coin->coin_type) : ''); ?>" 
                                                readonly>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <div class="controls">
                                            <div class="form-label"><?php echo e(__('Base Coin')); ?></div>
                                            <input type="text" class="form-control" 
                                                value="<?php echo e(isset($coin_pair_details->parent_coin) ? check_default_coin_type($coin_pair_details->parent_coin->coin_type) : ''); ?>" 
                                                readonly>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <div class="controls">
                                            <div class="form-label"><?php echo e(__('Minimum Amount For Future Trade')); ?></div>
                                            <input type="text" class="form-control" name="minimum_amount_future" 
                                                value="<?php echo e($coin_pair_details->minimum_amount_future); ?>">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <div class="controls">
                                            <div class="form-label"><?php echo e(__('Maintenance Margin Rate')); ?> (<?php echo e(__('Percentage')); ?> %)</div>
                                            <input type="text" class="form-control" name="maintenance_margin_rate" 
                                                value="<?php echo e($coin_pair_details->maintenance_margin_rate); ?>">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <div class="controls">
                                            <div class="form-label"><?php echo e(__('Funding Fee')); ?> (<?php echo e(__('Percentage')); ?> %)</div>
                                            <input type="text" class="form-control" name="leverage_fee" 
                                                value="<?php echo e($coin_pair_details->leverage_fee); ?>">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <div class="controls">
                                            <div class="form-label"><?php echo e(__('Maximum Leverage')); ?></div>
                                            <input type="text" class="form-control" name="max_leverage" 
                                                value="<?php echo e($coin_pair_details->max_leverage); ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-2">
                                    <button type="submit" class="btn theme-btn"><?php echo e(__('Submit')); ?></button>
                                </div>
                            </div>
                        </form>
                        
                       
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master',['menu'=>'coin', 'sub_menu'=>'coin_pair'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/tradexpro-admin/resources/views/admin/exchange/coin_pair/settings.blade.php ENDPATH**/ ?>