<?php $__env->startSection('title', isset($title) ? $title : ''); ?>
<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- breadcrumb -->
    <div class="custom-breadcrumb">
        <div class="row">
            <div class="col-5">
                <ul>
                    <li><?php echo e(__('Fiat Deposit')); ?></li>
                    <li class="active-item"><?php echo e($title); ?></li>
                </ul>
            </div>
            <div class="col-sm-7 text-right">
                <a class="add-btn theme-btn" href="<?php echo e(route('currencyPaymentMethodAdd')); ?>"><?php echo e(__('Add New')); ?></a>
            </div>
        </div>
    </div>
    <!-- /breadcrumb -->

    <!-- User Management -->
    <div class="user-management">
        <div class="row">
            <div class="col-12">
                <div class="header-bar p-4">
                    <div class="table-title">
                        <h3><?php echo e($title); ?></h3>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-area payment-table-area">
                        <div class="table-responsive">
                            <table id="table" class="table table-borderless custom-table display text-center" width="100%">
                                <thead>
                                <tr>
                                    <th scope="col"><?php echo e(__('Title')); ?></th>
                                    <th scope="col"><?php echo e(__('Payment Method')); ?></th>
                                    <th scope="col"><?php echo e(__('Status')); ?></th>
                                    <th scope="col"><?php echo e(__('Action')); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php if(isset($currency_deposit_payment_methods)): ?>
                                    <?php $__currentLoopData = $currency_deposit_payment_methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td> <?php echo e($value->title); ?> </td>
                                            <td> <?php echo e(currencyDepositPaymentMethod($value->payment_method)); ?> </td>
                                            <td>
                                                <div>
                                                    <label class="switch">
                                                        <input type="checkbox" onclick="statusChange('<?php echo e($value->id); ?>')"
                                                               id="notification" name="security" <?php if($value->status == STATUS_ACTIVE): ?> checked <?php endif; ?>>
                                                        <span class="slider" for="status"></span>
                                                    </label>
                                                </div>
                                            </td>
                                            <td>
                                                <ul class=" d-flex activity-menu">
                                                    <li>
                                                        <a title="<?php echo e(__('Edit')); ?>" href="<?php echo e(route("currencyPaymentMethodEdit",["id" => $value->id])); ?>">
                                                            <i class="fa fa-pencil"></i>
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a title="<?php echo e(__('Delete')); ?>" href="<?php echo e(route("currencyPaymentMethodDelete",["id" => $value->id])); ?>">
                                                            <i class="fa fa-trash"></i>
                                                        </a>
                                                    </li>
                                                </ul>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="6"><?php echo e(__('No data found')); ?></td>
                                    </tr>
                                <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /User Management -->

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>

        function statusChange(currency_payment_method_id) {
            $.ajax({
                type: "POST",
                url: "<?php echo e(route('currencyPaymentMethodStatus')); ?>",
                data: {
                    '_token': "<?php echo e(csrf_token()); ?>",
                    'id': currency_payment_method_id
                },
                success: function (data) {
                    console.log(data);
                }
            });
        }


        $('#table').DataTable({
            processing: true,
            serverSide: false,
            paging: true,
            searching: true,
            ordering:  true,
            select: false,
            bDestroy: true,
            order: [0, 'asc'],
            responsive: true,
            autoWidth: false,
            language: {
                "decimal":        "",
                "emptyTable":     "<?php echo e(__('No data available in table')); ?>",
                "info":           "<?php echo e(__('Showing')); ?> _START_ to _END_ of _TOTAL_ <?php echo e(__('entries')); ?>",
                "infoEmpty":      "<?php echo e(__('Showing')); ?> 0 to 0 of 0 <?php echo e(__('entries')); ?>",
                "infoFiltered":   "(<?php echo e(__('filtered from')); ?> _MAX_ <?php echo e(__('total entries')); ?>)",
                "infoPostFix":    "",
                "thousands":      ",",
                "lengthMenu":     "<?php echo e(__('Show')); ?> _MENU_ <?php echo e(__('entries')); ?>",
                "loadingRecords": "<?php echo e(__('Loading...')); ?>",
                "processing":     "",
                "search":         "<?php echo e(__('Search')); ?>:",
                "zeroRecords":    "<?php echo e(__('No matching records found')); ?>",
                "paginate": {
                    "first":      "<?php echo e(__('First')); ?>",
                    "last":       "<?php echo e(__('Last')); ?>",
                    "next":       '<?php echo e(__('Next')); ?> &#8250;',
                    "previous":   '&#8249; <?php echo e(__('Previous')); ?>'
                },
                "aria": {
                    "sortAscending":  ": activate to sort column ascending",
                    "sortDescending": ": activate to sort column descending"
                }
            },
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master',['menu'=>'currency_deposit', 'sub_menu'=>'payment_method_list'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/tradexpro-admin/resources/views/admin/payment-method/list.blade.php ENDPATH**/ ?>