<?php $__env->startSection('title', isset($title) ? $title : ''); ?>
<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- breadcrumb -->
    <div class="custom-breadcrumb">
        <div class="row">
            <div class="col-md-9">
                <ul>
                    <li><?php echo e(__('Coin Pair Settings')); ?></li>
                    <li class="active-item"><?php echo e($title); ?></li>
                </ul>
            </div>
            <div class="col-md-3 text-right">
                <a class="add-btn theme-btn" href="" data-toggle="modal" data-target="#pairModal"><i class="fa fa-plus"></i><?php echo e(__('Add New Pair')); ?></a>
            </div>
        </div>
    </div>
    <!-- /breadcrumb -->

    <!-- User Management -->
    <div class="user-management p-4">
        <div class="row">
            <div class="col-12">
                <div class="table-area">
                    <div>
                        <table id="table" class=" table table-borderless custom-table display text-lg-center" width="100%">
                            <thead>
                            <tr>
                                <th scope="col"><?php echo e(__('Trade Coin')); ?></th>
                                <th scope="col" class="all"><?php echo e(__('Base Coin')); ?></th>
                                <th scope="col"><?php echo e(__('Last Price')); ?></th>
                                <th scope="col" class="all"><?php echo e(__('Active Status')); ?></th>
                                <th scope="col" class="all"><?php echo e(__('Bot Trading')); ?></th>
                                <th scope="col" class="all"><?php echo e(__('Future Trading')); ?></th>
                                <th scope="col"><?php echo e(__('Created At')); ?></th>
                                <th scope="col" class="all"><?php echo e(__('Actions')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php if(isset($items[0])): ?>
                                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e(isset($item->child_coin) ? check_default_coin_type($item->child_coin->coin_type) : ''); ?></td>
                                        <td><?php echo e(isset($item->parent_coin) ? check_default_coin_type($item->parent_coin->coin_type) : ''); ?></td>
                                        <td><?php echo e($item->price); ?> <?php echo e(isset($item->parent_coin) ? check_default_coin_type($item->parent_coin->coin_type) : ''); ?></td>
                                        <td>
                                            <div>
                                                <label class="switch">
                                                    <input type="checkbox" onclick="return processForm('<?php echo e(encrypt($item->id)); ?>')"
                                                           id="notification" name="" <?php if($item->status == STATUS_ACTIVE): ?> checked <?php endif; ?>>
                                                    <span class="slider" for="status"></span>
                                                </label>
                                            </div>
                                        </td>
                                        <td>
                                            <div>
                                                <?php if($item->bot_possible == STATUS_ACTIVE): ?>
                                                <label class="switch">
                                                    <input type="checkbox" onclick="return processMarketBot('<?php echo e(encrypt($item->id)); ?>')"
                                                           id="notification" name="" <?php if($item->bot_trading == STATUS_ACTIVE): ?> checked <?php endif; ?>>
                                                    <span class="slider" for="status"></span>
                                                </label>
                                                <?php else: ?>
                                                    <button class="btn-sm btn-warning" data-toggle="tooltip" data-placement="top" title="<?php echo e(__('Bot trading is not possible for this pair')); ?>"><?php echo e(__('Bot Disable')); ?></button>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                        <td>
                                            <div>
                                                <label class="switch">
                                                    <input type="checkbox" onclick="return futureTradeStatus('<?php echo e(encrypt($item->id)); ?>')"
                                                        id="notification" name="" 
                                                        <?php if($item->enable_future_trade == STATUS_ACTIVE): ?> 
                                                            checked 
                                                        <?php endif; ?>>
                                                    <span class="slider" for="status"></span>
                                                </label>
                                            </div>
                                        </td>

                                        <td><?php echo e($item->created_at); ?></td>
                                        <td>
                                            <ul class="d-flex activity-menu">
                                                <li class="viewuser">
                                                    <a data-toggle="modal" data-target="#pair_edit_<?php echo e($item->id); ?>" title="<?php echo e(__('Edit')); ?>" class="btn btn-primary btn-sm">
                                                        <i class="fa fa-pencil"></i>
                                                    </a>
                                                </li>
                                                <li class="viewuser">
                                                    <a href="#delete1WV4d6uF6Ytu18v1Pl_<?php echo e(($item->id)); ?>" data-toggle="modal" title="<?php echo e(__("Delete")); ?>" class="btn btn-danger btn-sm">
                                                        <i class="fa fa-trash"></i>
                                                    </a>
                                                    <div id="delete1WV4d6uF6Ytu18v1Pl_<?php echo e(($item->id)); ?>" class="modal fade delete" role="dialog">
                                                        <div class="modal-dialog modal-sm">
                                                            <div class="modal-content">
                                                                <div class="modal-header"><h6 class="modal-title"><?php echo e(__('Delete')); ?></h6><button type="button" class="close" data-dismiss="modal">&times;</button></div>
                                                                <div class="modal-body"><p><?php echo e(__('Do you want to delete ?')); ?></p></div>
                                                                <div class="modal-footer"><button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(__("Close")); ?></button>
                                                                    <a class="btn btn-danger"href="<?php echo e(route('coinPairsDelete', encrypt($item->id))); ?>"><?php echo e(__('Confirm')); ?> </a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <?php if($item->is_chart_updated == STATUS_PENDING): ?>
                                                    <li class="viewuser">
                                                        <a href="#chart1WV4d6uF6Ytu18v1Pl_<?php echo e(($item->id)); ?>" data-toggle="modal" title="<?php echo e(__("Update Chart Data")); ?>" class="btn btn-success btn-sm">
                                                            <i class="fa fa-bar-chart"></i>
                                                        </a>
                                                        <div id="chart1WV4d6uF6Ytu18v1Pl_<?php echo e(($item->id)); ?>" class="modal fade delete" role="dialog">
                                                            <div class="modal-dialog modal-sm">
                                                                <div class="modal-content">
                                                                    <div class="modal-header"><h6 class="modal-title"><?php echo e(__('Update Chart Data')); ?></h6><button type="button" class="close" data-dismiss="modal">&times;</button></div>
                                                                    <div class="modal-body"><p><?php echo e(__('Do you want to get chart data from api ?')); ?></p></div>
                                                                    <div class="modal-footer"><button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(__("Close")); ?></button>
                                                                        <a class="btn btn-danger"href="<?php echo e(route('coinPairsChartUpdate', encrypt($item->id))); ?>"><?php echo e(__('Confirm')); ?> </a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </li>
                                                <?php endif; ?>
                                                <li class="viewuser">
                                                    <a href="<?php echo e(route('coinPairFutureSetting', encrypt($item->id))); ?>" title="<?php echo e(__("Settings")); ?>" class="btn btn-warning btn-sm">
                                                        <i class="fa fa-cog"></i>
                                                    </a>
                                                </li>
                                            </ul>
                                            <div id="pair_edit_<?php echo e($item->id); ?>" class="modal fade" role="dialog">
                                                <div class="modal-dialog">
                                                    <!-- Modal content-->
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                            <h4 class="modal-title"><?php echo e(__('Update Coin Pair')); ?></h4>
                                                        </div>
                                                        <div class="modal-body">
                                                            <?php echo e(Form::open(['route' => 'saveCoinPairSettings', 'files' => 'true' ])); ?>

                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <input type="hidden" name="edit_id" value="<?php echo e(encrypt($item->id)); ?>">
                                                                    <div class="form-group">
                                                                        <label class="form-label"><?php echo e(__('Base Coin')); ?></label>
                                                                        <select class=" form-control" name="parent_coin_id"  style="width: 100%;">
                                                                            <option value=""><?php echo e(__('Select')); ?></option>
                                                                            <?php if(isset($coins[0])): ?>
                                                                                <?php $__currentLoopData = $coins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                    <option <?php if($item->parent_coin_id == $coin->id): ?> selected <?php endif; ?> value="<?php echo e($coin->id); ?>"><?php echo e(check_default_coin_type($coin->coin_type)); ?></option>
                                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                            <?php endif; ?>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label class="form-label"><?php echo e(__('Pair Coin')); ?></label>
                                                                        <select class=" form-control" name="child_coin_id"  style="width: 100%;">
                                                                            <option value=""><?php echo e(__('Select')); ?></option>
                                                                            <?php if(isset($coins[0])): ?>
                                                                                <?php $__currentLoopData = $coins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                    <option <?php if($item->child_coin_id == $coin->id): ?> selected <?php endif; ?> value="<?php echo e($coin->id); ?>"><?php echo e(check_default_coin_type($coin->coin_type)); ?></option>
                                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                            <?php endif; ?>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label class="form-label"><?php echo e(__('Is this pair listed in bot api ?')); ?></label>
                                                                        <select class=" form-control" name="pair_listed_api"  style="width: 100%;">
                                                                            <option <?php if($item->is_token == STATUS_ACTIVE): ?> selected <?php endif; ?> value="2"><?php echo e(__('No')); ?></option>
                                                                            <option <?php if($item->is_token == STATUS_DEACTIVE): ?> selected <?php endif; ?> value="1"><?php echo e(__('Yes')); ?></option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <?php if(env('APP_MODE') == 'myDemo'): ?>
                                                                    <div class="col-md-6">
                                                                        <div class="form-group">
                                                                            <label class="form-label"><?php echo e(__('Last Price')); ?></label>
                                                                            <input type="text" class="form-control" name="price" value="<?php echo e($item->price); ?>">
                                                                        </div>
                                                                    </div>
                                                                <?php endif; ?>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-4">
                                                                    <button class="btn btn-info" type="submit"><?php echo e(__('Update')); ?></button>
                                                                </div>
                                                            </div>
                                                            <?php echo e(Form::close()); ?>

                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal -->
    <div id="pairModal" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title"><?php echo e(__('Add Coin Pair')); ?></h4>
                </div>
                <div class="modal-body">
                    <?php echo e(Form::open(['route' => 'saveCoinPairSettings', 'files' => 'true' ])); ?>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label"><?php echo e(__('Base Coin')); ?></label>
                                <div class="cp-select-area">
                                    <select class=" form-control" name="parent_coin_id"  style="width: 100%;">
                                        <option value=""><?php echo e(__('Select')); ?></option>
                                        <?php if(isset($coins[0])): ?>
                                            <?php $__currentLoopData = $coins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($coin->id); ?>"><?php echo e(check_default_coin_type($coin->coin_type)); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label"><?php echo e(__('Pair Coin')); ?></label>
                                <div class="cp-select-area">
                                    <select class=" form-control" name="child_coin_id"  style="width: 100%;">
                                        <option value=""><?php echo e(__('Select')); ?></option>
                                        <?php if(isset($coins[0])): ?>
                                            <?php $__currentLoopData = $coins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($coin->id); ?>"><?php echo e(check_default_coin_type($coin->coin_type)); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label"><?php echo e(__('Get last price from api ?')); ?></label>
                                <div class="cp-select-area">
                                    <select name="get_price_api" id="" class="form-control">
                                        <option value="1"><?php echo e(__('Yes')); ?></option>
                                        <option value="2"><?php echo e(__('No')); ?></option>
                                    </select>
                                </div>
                                <small class="text-warning"><?php echo e(__('If no , please input the initial price')); ?></small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label"><?php echo e(__('Initial Price')); ?></label>
                                <input type="text" class="form-control" name="price" >
                            </div>
                        </div>
                    </div>
                    
                    <div class="modal-footer mt-4">
                        <button class="btn btn-warning text-white" type="submit"><?php echo e(__('Save')); ?></button>
                        <button type="button" class="btn btn-dark" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                    </div>
                    <?php echo e(Form::close()); ?>

                </div>
               
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>

            $('#table').DataTable({
                responsive: true,
                paging: true,
                searching: true,
                ordering: true,
                select: false,
                bDestroy: true
            });

            function processForm(active_id) {

                $.ajax({
                    type: "POST",
                    url: "<?php echo e(route('changeCoinPairStatus')); ?>",
                    data: {
                        '_token': "<?php echo e(csrf_token()); ?>",
                        'active_id': active_id
                    },
                    success: function (data) {
                        if(data.success == true) {
                            VanillaToasts.create({
                                text: data.message,
                                backgroundColor: "linear-gradient(135deg, #73a5ff, #5477f5)",
                                type: 'success',
                                timeout: 5000
                            });
                        } else {
                            VanillaToasts.create({
                                text: data.message,
                                type: 'warning',
                                timeout: 5000
                            });
                        }
                    }
                });
            }
            function processMarketBot(active_id) {

                $.ajax({
                    type: "POST",
                    url: "<?php echo e(route('changeCoinPairBotStatus')); ?>",
                    data: {
                        '_token': "<?php echo e(csrf_token()); ?>",
                        'active_id': active_id
                    },
                    success: function (data) {
                        if(data.success == true) {
                            VanillaToasts.create({
                                text: data.message,
                                backgroundColor: "linear-gradient(135deg, #73a5ff, #5477f5)",
                                type: 'success',
                                timeout: 5000
                            });
                        } else {
                            VanillaToasts.create({
                                text: data.message,
                                type: 'warning',
                                timeout: 5000
                            });
                            
                        }
                    }
                });
            }

            function futureTradeStatus(active_id) {

                $.ajax({
                    type: "POST",
                    url: "<?php echo e(route('changeFutureTradeStatus')); ?>",
                    data: {
                        '_token': "<?php echo e(csrf_token()); ?>",
                        'active_id': active_id
                    },
                    success: function (data) {
                        if(data.success == true) {
                            VanillaToasts.create({
                                text: data.message,
                                backgroundColor: "linear-gradient(135deg, #73a5ff, #5477f5)",
                                type: 'success',
                                timeout: 5000
                            });
                        } else {
                            VanillaToasts.create({
                                text: data.message,
                                type: 'warning',
                                timeout: 5000
                            });
                            
                        }
                    }
                });
            }

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master',['menu'=>'coin', 'sub_menu'=>'coin_pair'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/tradexpro-admin/resources/views/admin/exchange/coin_pair/list.blade.php ENDPATH**/ ?>