<?php $__env->startSection('title', isset($title) ? $title : ''); ?>
<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- breadcrumb -->
    <div class="custom-breadcrumb">
        <div class="row">
            <div class="col-12">
                <ul>
                    <li><?php echo e(__('Settings')); ?></li>
                    <li class="active-item"><?php echo e($title); ?></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- /breadcrumb -->

    <!-- User Management -->
    <div class="user-management pt-4">
        <div class="row no-gutters">
            <div class="col-12 col-lg-3 col-xl-2">
                <ul class="nav user-management-nav mb-3" id="pills-tab" role="tablist">
                    <?php if(isset($tab) && ($tab=='api_config')): ?>
                    <?php else: ?>
                        <li class="nav-item">
                            <a class="<?php if(isset($tab) && $tab=='two_factor_list'): ?> active <?php endif; ?> nav-link " id="pills-user-tab"
                               data-toggle="pill" data-controls="two_factor_list" href="#two_factor_list" role="tab"
                               aria-controls="pills-user" aria-selected="true">
                                <span><?php echo e(__('Two Factor List')); ?></span>
                            </a>
                        </li>
                        
                        <li class="nav-item">
                            <a class="<?php if(isset($tab) && $tab=='two_factor_withdraw'): ?> active <?php endif; ?> nav-link " id="pills-user-tab"
                               data-toggle="pill" data-controls="two_factor_withdraw" href="#two_factor_withdraw" role="tab"
                               aria-controls="pills-user" aria-selected="true">
                                <span><?php echo e(__('Two Factor Withdraw')); ?></span>
                            </a>
                        </li>
                        
                    <?php endif; ?>
                </ul>
            </div>
            <div class="col-12 col-lg-9 col-xl-10">
                <div class="tab-content" id="pills-tabContent">
                    <div class="tab-pane show <?php if(isset($tab) && $tab=='two_factor_list'): ?>  active <?php endif; ?>" id="two_factor_list"
                         role="tabpanel" aria-labelledby="pills-user-tab">
                        <?php echo $__env->make('admin.two-factor.include.list', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="tab-pane show <?php if(isset($tab) && $tab=='two_factor_login'): ?>  active <?php endif; ?>" id="two_factor_login"
                         role="tabpanel" aria-labelledby="pills-user-tab">
                        <?php echo $__env->make('admin.two-factor.include.login', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="tab-pane show <?php if(isset($tab) && $tab=='two_factor_withdraw'): ?>  active <?php endif; ?>" id="two_factor_withdraw"
                         role="tabpanel" aria-labelledby="pills-user-tab">
                        <?php echo $__env->make('admin.two-factor.include.withdraw', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="tab-pane show <?php if(isset($tab) && $tab=='two_factor_swap'): ?>  active <?php endif; ?>" id="two_factor_swap"
                         role="tabpanel" aria-labelledby="pills-user-tab">
                        <?php echo $__env->make('admin.two-factor.include.swap', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /User Management -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        (function ($) {
            "use strict";

            $('.nav-link').on('click', function () {
                $('.nav-link').removeClass('active');
                $(this).addClass('active');
                var str = '#' + $(this).data('controls');
                $('.tab-pane').removeClass('show active');
                $(str).addClass('show active');
            });
        })(jQuery)

        function statusChange(twoFactorId) {
            $.ajax({
                type: "POST",
                url: "<?php echo e(route('SaveTwoFactor')); ?>",
                data: {
                    '_token': "<?php echo e(csrf_token()); ?>",
                    'id': twoFactorId
                },
                success: function (data) {
                    console.log(data);
                }
            });
        }

        $('#table').DataTable({
            processing: true,
            serverSide: false,
            paging: true,
            searching: true,
            ordering:  true,
            select: false,
            bDestroy: true,
            order: [0, 'asc'],
            responsive: true,
            autoWidth: false,
            language: {
                "decimal":        "",
                "emptyTable":     "<?php echo e(__('No data available in table')); ?>",
                "info":           "<?php echo e(__('Showing')); ?> _START_ to _END_ of _TOTAL_ <?php echo e(__('entries')); ?>",
                "infoEmpty":      "<?php echo e(__('Showing')); ?> 0 to 0 of 0 <?php echo e(__('entries')); ?>",
                "infoFiltered":   "(<?php echo e(__('filtered from')); ?> _MAX_ <?php echo e(__('total entries')); ?>)",
                "infoPostFix":    "",
                "thousands":      ",",
                "lengthMenu":     "<?php echo e(__('Show')); ?> _MENU_ <?php echo e(__('entries')); ?>",
                "loadingRecords": "<?php echo e(__('Loading...')); ?>",
                "processing":     "",
                "search":         "<?php echo e(__('Search')); ?>:",
                "zeroRecords":    "<?php echo e(__('No matching records found')); ?>",
                "paginate": {
                    "first":      "<?php echo e(__('First')); ?>",
                    "last":       "<?php echo e(__('Last')); ?>",
                    "next":       '<?php echo e(__('Next')); ?> &#8250;',
                    "previous":   '&#8249; <?php echo e(__('Previous')); ?>'
                },
                "aria": {
                    "sortAscending":  ": activate to sort column ascending",
                    "sortDescending": ": activate to sort column descending"
                }
            },
        });
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.master',['menu'=>'setting', 'sub_menu'=>'two_factor'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/tradexpro-admin/resources/views/admin/two-factor/two-factor.blade.php ENDPATH**/ ?>