<div class="header-bar">
    <div class="table-title">
        <h3><?php echo e(__('Capcha Settings')); ?></h3>
    </div>
</div>
<div class="profile-info-form">
    <form action="<?php echo e(route('adminCapchaSettings')); ?>" method="post" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="row">
            <div class="col-lg-6 col-12 mt-20">
                <div class="form-group">
                    <label><?php echo e(__('Choose Captcha Type')); ?></label>
                    <div class="cp-select-area">
                        <select name="select_captcha_type" class="form-control">
                            <?php $__currentLoopData = captchTypeList(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $captcha_key=>$captcha_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($captcha_key); ?>"
                                    <?php if(isset($settings['select_captcha_type']) && $settings['select_captcha_type'] == $captcha_key): ?>
                                        selected
                                    <?php endif; ?>><?php echo e($captcha_item); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <h4 class="text-white"><?php echo e(__('Google Re-captcha Credentials')); ?></h4>
            </div>
            <div class="col-lg-6 col-12 mt-20">
                <div class="form-group">
                    <label
                        for="#"><?php echo e(__('Google Re-Captcha Secret')); ?> </label>
                    <?php if(env('APP_MODE') == 'demo'): ?>
                        <input class="form-control" value="<?php echo e('disablefordemo'); ?>">
                    <?php else: ?>
                    <input class="form-control " type="text"
                           name="NOCAPTCHA_SECRET" placeholder=""
                           value="<?php echo e($settings['NOCAPTCHA_SECRET'] ?? ''); ?>">
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-lg-6 col-12 mt-20">
                <div class="form-group">
                    <label
                        for="#"><?php echo e(__('Google Re-Captcha Site key')); ?> </label>
                    <?php if(env('APP_MODE') == 'demo'): ?>
                        <input class="form-control" value="<?php echo e('disablefordemo'); ?>">
                    <?php else: ?>
                    <input class="form-control " type="text"
                           name="NOCAPTCHA_SITEKEY" placeholder=""
                           value="<?php echo e($settings['NOCAPTCHA_SITEKEY'] ?? ''); ?>">
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <h4 class="text-white"><?php echo e(__('GeeTest Captcha Credentials')); ?></h4>
            </div>
            <div class="col-lg-6 col-12 mt-20">
                <div class="form-group">
                    <label
                        for="#"><?php echo e(__('GeeTest Captcha ID')); ?> </label>
                    <?php if(env('APP_MODE') == 'demo'): ?>
                        <input class="form-control" value="<?php echo e('disablefordemo'); ?>">
                    <?php else: ?>
                    <input class="form-control " type="text"
                           name="GEETEST_CAPTCHA_ID" placeholder=""
                           value="<?php echo e($settings['GEETEST_CAPTCHA_ID'] ?? ''); ?>">
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-lg-6 col-12 mt-20">
                <div class="form-group">
                    <label
                        for="#"><?php echo e(__('GeeTest Captcha Key')); ?> </label>
                    <?php if(env('APP_MODE') == 'demo'): ?>
                        <input class="form-control" value="<?php echo e('disablefordemo'); ?>">
                    <?php else: ?>
                    <input class="form-control " type="text"
                           name="GEETEST_CAPTCHA_KEY" placeholder=""
                           value="<?php echo e($settings['GEETEST_CAPTCHA_KEY'] ?? ''); ?>">
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-2 col-12 mt-20">
                <button class="button-primary theme-btn"><?php echo e(__('Update')); ?></button>
            </div>
        </div>
    </form>
</div>


<?php /**PATH /var/www/html/tradexpro-admin/resources/views/admin/settings/setting/captcha.blade.php ENDPATH**/ ?>