<div class="row">
    <div class="col-xl-4 col-md-6 col-12 mb-4">
        <div class="card status-card status-card-bg-read">
            <div class="card-body py-0">
                <div class="status-card-inner">
                    <div class="content">
                        <p><?php echo e(__('Total User')); ?></p>
                        <h3><?php echo e($total_user); ?></h3>
                        <a href="<?php echo e(route('adminUsers')); ?>" class=" mt-3 btn btn-sm btn-warning"><?php echo e(__("Show More")); ?></a>
                    </div>
                    <div class="icon">
                        <img src="<?php echo e(asset('assets/admin/images/status-icons/team.svg')); ?>" class="img-fluid" alt="">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-4 col-md-6 col-12 mb-4">
        <div class="card status-card status-card-bg-average">
            <div class="card-body py-0">
                <div class="status-card-inner">
                    <div class="content">
                        <p><?php echo e(__('Total User Coin')); ?></p>
                        <h3><?php echo e(number_format($total_coin,2)); ?> BTC</h3>
                        <a href="<?php echo e(route('adminUserCoinList')); ?>" class=" mt-3 btn btn-sm btn-warning"><?php echo e(__("Show More")); ?></a>
                    </div>
                    <div class="icon">
                        <img src="<?php echo e(asset('assets/admin/images/status-icons/money.svg')); ?>" class="img-fluid" alt="">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-4 col-md-6 col-12 mb-4">
        <div class="card status-card status-card-bg-average">
            <div class="card-body py-0">
                <div class="status-card-inner">
                    <div class="content">
                        <p><?php echo e(__('Total Earning')); ?></p>
                        <h3><?php echo e(number_format($total_earning,8)); ?></h3>
                        <a href="<?php echo e(route('adminEarningReport')); ?>" class=" mt-3 btn btn-sm btn-warning"><?php echo e(__("Show More")); ?></a>
                    </div>
                    <div class="icon">
                        <img src="<?php echo e(asset('assets/admin/images/status-icons/funds.svg')); ?>" class="img-fluid" alt="">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-4 col-md-6 col-12 mb-4">
        <div class="card status-card status-card-bg-read">
            <div class="card-body py-0">
                <div class="status-card-inner">
                    <div class="content">
                        <p><?php echo e(__('Active Buy Order')); ?></p>
                        <h3><?php echo e($active_buy); ?></h3>
                        <a href="<?php echo e(route('adminAllOrdersHistoryBuy')); ?>" class=" mt-3 btn btn-sm btn-warning"><?php echo e(__("Show More")); ?></a>
                    </div>
                    <div class="icon">
                        <img src="<?php echo e(asset('assets/admin/images/status-icons/money.svg')); ?>" class="img-fluid" alt="">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-4 col-md-6 col-12 mb-4">
        <div class="card status-card status-card-bg-orange">
            <div class="card-body py-0">
                <div class="status-card-inner">
                    <div class="content">
                        <p><?php echo e(__('Active Sell Order')); ?></p>
                        <h3><?php echo e($active_sell); ?></h3>
                        <a href="<?php echo e(route('adminAllOrdersHistorySell')); ?>" class=" mt-3 btn btn-sm btn-warning"><?php echo e(__("Show More")); ?></a>
                    </div>
                    <div class="icon">
                        <img src="<?php echo e(asset('assets/admin/images/status-icons/money.svg')); ?>" class="img-fluid" alt="">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-4 col-md-6 col-12 mb-4">
        <div class="card status-card status-card-bg-orange">
            <div class="card-body py-0">
                <div class="status-card-inner">
                    <div class="content">
                        <p><?php echo e(__('Total Transaction')); ?></p>
                        <h3><?php echo e(number_format($total_transaction,2)); ?></h3>
                        <a href="<?php echo e(route('adminAllTransactionHistory')); ?>" class=" mt-3 btn btn-sm btn-warning"><?php echo e(__("Show More")); ?></a>
                    </div>
                    <div class="icon">
                        <img src="<?php echo e(asset('assets/admin/images/status-icons/funds.svg')); ?>" class="img-fluid" alt="">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /var/www/html/tradexpro-admin/resources/views/admin/dashboard/dashboard_status.blade.php ENDPATH**/ ?>