<?php $__env->startSection('title', isset($title) ? $title : ''); ?>
<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- breadcrumb -->
    <div class="custom-breadcrumb">
        <div class="row">
            <div class="col-md-9">
                <ul>
                    <li><?php echo e(__('Coin')); ?></li>
                    <li class="active-item"><?php echo e($title); ?></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- /breadcrumb -->

    <!-- User Management -->
    <div class="user-management">
        <div class="row">
            <div class="col-12">
                <div class="profile-info-form">
                    <div>
                        <?php echo e(Form::open(['route'=>'adminCoinSaveProcess', 'files' => true])); ?>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <div class="controls">
                                        <div class="form-label"><?php echo e(__('Coin Type')); ?></div>
                                        <input type="text" class="form-control" name="coin_type" <?php if(isset($item)): ?>value="<?php echo e($item->coin_type); ?>" <?php else: ?> value="<?php echo e(old('coin_type')); ?>" <?php endif; ?>>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <div class="controls">
                                        <div class="form-label"><?php echo e(__('Coin Full Name')); ?></div>
                                        <input type="text" class="form-control" name="name" <?php if(isset($item)): ?>value="<?php echo e($item->name); ?>" <?php else: ?> value="<?php echo e(old('name')); ?>" <?php endif; ?>>
                                        <pre class="text-danger"><?php echo e($errors->first('name')); ?></pre>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <?php if($item->currency_type == CURRENCY_TYPE_CRYPTO): ?>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <div class="controls">
                                            <div class="form-label"><?php echo e(__('Coin API')); ?></div>
                                            <select class="form-control" name="network" id="">
                                                <?php $__currentLoopData = api_settings(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option <?php if(isset($item) && $item->network == $key): ?> selected <?php endif; ?> value="<?php echo e($key); ?>"><?php echo e($val); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <div class="controls">
                                            <div class="form-label"><?php echo e(__('Coin Price (in USD)')); ?></div>
                                            <div class="input-group mb-3 w-85 ">
                                                <input type="text" class="form-control" name="coin_price" value="<?php echo e($item->coin_price); ?>">
                                                <div class="input-group-append">
                                                    <span class="input-group-text px-4"><span class="currency text-warning">USD</span></span>
                                                </div>
                                            </div>
                                            <small><?php echo e(__('Coin price in USD. it will update by currency api regularly')); ?></small>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <div class="controls">
                                        <div class="form-label"><?php echo e(__('Minimum Withdrawal')); ?></div>
                                        <input type="text" class="form-control" name="minimum_withdrawal"
                                               <?php if(isset($item)): ?>value="<?php echo e($item->minimum_withdrawal); ?>" <?php else: ?> value="0.00000001" <?php endif; ?> >
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <div class="controls">
                                        <div class="form-label"><?php echo e(__('Maximum Withdrawal')); ?></div>
                                        <input type="text" class="form-control" name="maximum_withdrawal"
                                               <?php if(isset($item)): ?>value="<?php echo e($item->maximum_withdrawal); ?>" <?php else: ?> value="99999999" <?php endif; ?>>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <div class="controls">
                                        <div class="form-label"><?php echo e(__('Minimum Buy Amount')); ?></div>
                                        <input type="text" class="form-control" name="minimum_buy_amount"
                                               <?php if(isset($item)): ?>value="<?php echo e($item->minimum_buy_amount); ?>" <?php else: ?> value="0.00000010" <?php endif; ?> >
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <div class="controls">
                                        <div class="form-label"><?php echo e(__('Minimum Sell Amount')); ?></div>
                                        <input type="text" class="form-control" name="minimum_sell_amount"
                                               <?php if(isset($item)): ?>value="<?php echo e($item->minimum_sell_amount); ?>" <?php else: ?> value="0.00000010" <?php endif; ?>>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <div class="controls">
                                        <div class="form-label"><b><?php echo e(__('Withdrawal Setting')); ?></b></div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <div class="controls">
                                        <div class="form-label"><?php echo e(__('Withdrawal Fees Type')); ?></div>
                                        <select name="withdrawal_fees_type" id="" class="form-control">
                                            <?php $__currentLoopData = discount_type(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option <?php if(isset($item) && ($item->withdrawal_fees_type == $key)): ?> selected <?php endif; ?> value="<?php echo e($key); ?>"><?php echo e($val); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <div class="controls">
                                        <div class="form-label"><?php echo e(__('Withdrawal Fees')); ?></div>
                                        <input type="text" class="form-control" name="withdrawal_fees"
                                               <?php if(isset($item)): ?>value="<?php echo e($item->withdrawal_fees); ?>" <?php else: ?> value="0.00000010" <?php endif; ?>>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <div class="controls">
                                        <div class="form-label"><?php echo e(__('Withdrawal limit for admin approval')); ?></div>
                                        <input type="text" class="form-control" name="max_send_limit"
                                               <?php if(isset($item)): ?>value="<?php echo e($item->max_send_limit); ?>" <?php else: ?> value="0" <?php endif; ?>>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><?php echo e(__('Enable admin approval ')); ?></label>
                                    <div class="cp-select-area">
                                        <select name="admin_approval" class="form-control">
                                            <option <?php if($item->admin_approval == STATUS_ACTIVE): ?> selected <?php endif; ?> value="<?php echo e(STATUS_ACTIVE); ?>"><?php echo e(__("Yes")); ?></option>
                                            <option <?php if($item->admin_approval == STATUS_REJECTED): ?> selected <?php endif; ?> value="<?php echo e(STATUS_REJECTED); ?>"><?php echo e(__("No")); ?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-3">
                            <div class="col-md-2">
                                <div class="form-group">
                                    <div class="controls">
                                        <div class="form-label"><?php echo e(__('Deposit Status')); ?></div>
                                        <label class="switch">
                                            <input type="checkbox" name="is_deposit" <?php if(isset($item) && $item->is_deposit==1): ?>checked  <?php endif; ?>>
                                            <span class="slider"></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <div class="controls">
                                        <div class="form-label"><?php echo e(__('Withdrawal Status')); ?></div>
                                        <label class="switch">
                                            <input type="checkbox" name="is_withdrawal" <?php if(isset($item) && $item->is_withdrawal==1): ?>checked  <?php endif; ?>>
                                            <span class="slider"></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <div class="controls">
                                        <div class="form-label"><?php echo e(__('Trading Status')); ?></div>
                                        <label class="switch">
                                            <input type="checkbox" name="trade_status" <?php if(isset($item) && $item->trade_status==1): ?>checked  <?php endif; ?>>
                                            <span class="slider"></span>
                                        </label>

                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <div class="controls">
                                        <div class="form-label"><?php echo e(__('Active Status')); ?></div>
                                        <label class="switch">
                                            <input type="checkbox" name="status" <?php if(isset($item) && $item->status==1): ?>checked  <?php endif; ?>>
                                            <span class="slider"></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <?php if(isset($module) && isset($module['DemoTrade'])): ?>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <div class="controls">
                                        <div class="form-label"><?php echo e(__('Demo Trade Status')); ?></div>
                                        <label class="switch">
                                            <input type="checkbox" name="is_demo_trade" <?php if(isset($item) && $item->is_demo_trade==1): ?>checked  <?php endif; ?>>
                                            <span class="slider"></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <div class="form-label"><?php echo e(__('Coin Icon')); ?></div>
                                    <div class="input-group">
                                        <span class="input-group-btn">
                                            <span class="btn btn-default btn-file">
                                                <input type="file" name="coin_icon">
                                            </span>
                                        </span>
                                        <img width="150px" src="<?php echo e(empty($item->coin_icon) ? '' : show_image_path($item->coin_icon,'coin/')); ?>">
                                    </div>
                                    <img id='img-upload'/>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-2">
                                <?php if(isset($item)): ?><input type="hidden" name="coin_id" value="<?php echo e(encrypt($item->id)); ?>">  <?php endif; ?>
                                <button type="submit" class="btn theme-btn"><?php echo e($button_title); ?></button>
                            </div>
                        </div>
                        <?php echo e(Form::close()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /User Management -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master',['menu'=>'coin', 'sub_menu' => 'coin_list'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/tradexpro-admin/resources/views/admin/coin-order/edit_coin.blade.php ENDPATH**/ ?>