<?php $__env->startSection('title', isset($title) ? $title : ''); ?>
<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- breadcrumb -->
    <div class="custom-breadcrumb">
        <div class="row">
            <div class="col-md-9">
                <ul>
                    <li><?php echo e(__('Coin')); ?></li>
                    <li class="active-item"><?php echo e($title); ?></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- /breadcrumb -->

    <!-- User Management -->
    <div class="user-management">
        <div class="row">
            <div class="col-12">
                <div class="profile-info-form">
                    <div>
                        <?php echo e(Form::open(['route'=>'adminSaveCoin', 'files' => true])); ?>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <div class="controls">
                                        <div class="form-label"><?php echo e(__('Currency Type')); ?></div>
                                        <select class="form-control" name="currency_type" id="currency_type">
                                            <?php $__currentLoopData = getTradeCurrencyType(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <div class="controls">
                                        <div class="form-label"><?php echo e(__('Coin Full Name')); ?></div>
                                        <input type="text" class="form-control" name="name" value="<?php echo e(old('name')); ?>">
                                        <pre class="text-danger"><?php echo e($errors->first('name')); ?></pre>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <div class="controls">
                                        <div class="form-label"><?php echo e(__('Coin Type')); ?></div>
                                        <div class="d-none" id="coin_type_input">
                                            <input id="coin_type_input_" type="text" class="form-control" value="<?php echo e(old('coin_type')); ?>">
                                        </div>
                                        <div class="" id="coin_type_select">
                                            <select id="coin_type_select_" class="form-control">
                                                <?php $__currentLoopData = $currency; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($currency->code); ?>" data-price="<?php echo e($currency->rate); ?>" ><?php echo e($currency->code); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <small><?php echo e(__('Please make sure your coin type is right. Never input wrong coin type')); ?></small>
                                        <pre class="text-danger"><?php echo e($errors->first('coin_type')); ?></pre>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="coin_rate_api" class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(__('Get coin rate from api ?')); ?></label>
                                    <div class="cp-select-area">
                                        <select name="get_price_api" id="" class="form-control">
                                            <option value="1"><?php echo e(__('Yes')); ?></option>
                                            <option value="2"><?php echo e(__('No')); ?></option>
                                        </select>
                                    </div>
                                    <small class="text-warning"><?php echo e(__('If no , please input the coin price')); ?></small>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <div class="controls">
                                        <div class="form-label"><?php echo e(__('Coin Price (in USD)')); ?></div>
                                        <div class="input-group w-85 ">
                                            <input type="text" class="form-control" name="coin_price" value="<?php echo e(old('coin_price')); ?>">
                                            <div class="input-group-append">
                                                <span class="input-group-text px-4"><span class="currency text-warning">USD</span></span>
                                            </div>
                                        </div>
                                        <small><?php echo e(__('Coin price in USD. it will update by currency api regularly')); ?></small>
                                        <pre class="text-danger"><?php echo e($errors->first('coin_price')); ?></pre>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="coin_api" class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <div class="controls">
                                        <div class="form-label"><?php echo e(__('Coin API')); ?></div>
                                        <div class="cp-select-area">
                                            <select name="network" id="" class="form-control">
                                                <?php $__currentLoopData = api_settings(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <small><?php echo e(__('Please make sure your coin API is right.You never change this API. So be careful')); ?></small>
                                        <pre class="text-danger"><?php echo e($errors->first('network')); ?></pre>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-2">
                                <button type="submit" class="btn theme-btn"><?php echo e($button_title); ?></button>
                            </div>
                        </div>
                        <?php echo e(Form::close()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /User Management -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script>
    "use strict";
    let currency = 1;

    function add_coin_ui_change(){ // name="coin_type"
        let coin_type_input  = document.getElementById("coin_type_input");
        let coin_type_select = document.getElementById("coin_type_select");


        if(currency == 1){
            $("#coin_type_input_").attr("name","coin_type");
            $("#coin_type_select_").attr("name","");

            coin_type_select.classList.add("d-none");
            coin_type_input.classList.remove("d-none");
            $("#coin_api").show()
            $("#coin_rate_api").show()
        }
        
        if(currency == 2){
            $("#coin_type_input_").attr("name","")
            $("#coin_type_select_").attr("name","coin_type")

            coin_type_select.classList.remove("d-none");
            coin_type_input.classList.add("d-none");

            $("#coin_api").hide();
            $("#coin_rate_api").hide();
        }
    }

    function currency_change(event) {
        currency = event.target.value;
        add_coin_ui_change();
    }
    add_coin_ui_change();
    $("#currency_type").on("change", currency_change);
    $("#coin_type_select_").on("change", (e)=>{
        let rate = $("#coin_type_select_").find(':selected').data("price")
        $('input[name="coin_price"]').val(rate);
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master',['menu'=>'coin', 'sub_menu' => 'coin_list'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/tradexpro-admin/resources/views/admin/coin-order/add_coin.blade.php ENDPATH**/ ?>