<?php $__env->startSection('title', isset($title) ? $title : ''); ?>
<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- breadcrumb -->
    <div class="custom-breadcrumb">
        <div class="row">
            <div class="col-md-5">
                <ul>
                    <li><?php echo e(__('Currency Management')); ?></li>
                    <li class="active-item"><?php echo e($title); ?></li>
                </ul>
            </div>
            <div class="col-md-7 text-md-right text-left mt-3 mt-md-0">
                <a class="btn btn-info" href="#" onclick="getallCurrency()"><?php echo e(__('Get all currency')); ?></a>
                <a class="btn btn-success" href="<?php echo e(route('adminCurrencyRate')); ?>"><?php echo e(__('Live update rate')); ?></a>
                <a class="btn btn-warning" href="<?php echo e(route('adminCurrencyAdd')); ?>"><?php echo e(__('Add New Currency')); ?></a>
            </div>
        </div>
    </div>
    <!-- /breadcrumb -->

    <!-- User Management -->
    <div class="user-management">
        <div class="row">
            <div class="col-12">
                <div class="card-body">
                    <div class="table-area payment-table-area">
                        <div class="table-responsive">
                            <table id="table" class="table table-borderless custom-table display text-center" width="100%">
                                <thead>
                                <tr>
                                    <th scope="col"><?php echo e(__('Name')); ?></th>
                                    <th scope="col"><?php echo e(__('Code')); ?></th>
                                    <th scope="col"><?php echo e(__('Symbol')); ?></th>
                                    <th scope="col"><?php echo e(__('Rate')); ?></th>
                                    <th scope="col"><?php echo e(__('Status')); ?></th>
                                    <th scope="col"><?php echo e(__('Action')); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php if(isset($items[0])): ?>
                                    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td> <?php echo e($value->name); ?> </td>
                                            <td> <?php echo e($value->code); ?> </td>
                                            <td> <?php echo e($value->symbol); ?> </td>
                                            <td> <?php echo e($value->rate.' '.' USD/'.$value->code); ?> </td>
                                            <td>
                                                <div>
                                                    <label class="switch">
                                                        <input type="checkbox" onclick="return processFormCall(this,'<?php echo e($value->id); ?>')"
                                                               id="notification" name="security" <?php if($value->status == STATUS_ACTIVE): ?> checked <?php endif; ?>>
                                                        <span class="slider" for="status"></span>
                                                    </label>
                                                </div>
                                            </td>
                                            <td>
                                                <ul class=" align-items-center text-center">
                                                    <li>
                                                        <a title="<?php echo e(__('Edit')); ?>" href="<?php echo e(route("adminCurrencyEdit",["id" => $value->id])); ?>">
                                                            <i class="fa fa-pencil"></i>
                                                        </a>
                                                    </li>
                                                </ul>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="6"><?php echo e(__('No data found')); ?></td>
                                    </tr>
                                <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /User Management -->

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>

        function processFormCall(e,active_id) {
            $.ajax({
                type: "POST",
                url: "<?php echo e(route('adminCurrencyStatus')); ?>",
                data: {
                    '_token': "<?php echo e(csrf_token()); ?>",
                    'active_id': active_id
                },
                success: function (data) {
                   if(data.success)
                   { 
                        VanillaToasts.create({
                        text: data.message,
                        backgroundColor: "linear-gradient(135deg, #73a5ff, #5477f5)",
                        type: 'success',
                        timeout: 40000
                        });
                   }else{
                        e.checked = false;
                        VanillaToasts.create({
                        text: data.message,
                        backgroundColor: "linear-gradient(135deg, #73a5ff, #5477f5)",
                        type: 'warning',
                        timeout: 40000
                        });
                   }
                    console.log(data,e);
                }
            });
        }

        function getallCurrency(){
            $.ajax({
                type: "POST",
                url: "<?php echo e(route('adminAllCurrency')); ?>",
                data: {
                    '_token': "<?php echo e(csrf_token()); ?>"
                },
                success: function (data) {
                    window.location.reload(true);
                }
            });
        }

        $('#table').DataTable({
            processing: true,
            serverSide: false,
            paging: true,
            searching: true,
            ordering:  true,
            select: false,
            bDestroy: true,
            order: [0, 'asc'],
            responsive: true,
            autoWidth: false,
            language: {
                "decimal":        "",
                "emptyTable":     "<?php echo e(__('No data available in table')); ?>",
                "info":           "<?php echo e(__('Showing')); ?> _START_ to _END_ of _TOTAL_ <?php echo e(__('entries')); ?>",
                "infoEmpty":      "<?php echo e(__('Showing')); ?> 0 to 0 of 0 <?php echo e(__('entries')); ?>",
                "infoFiltered":   "(<?php echo e(__('filtered from')); ?> _MAX_ <?php echo e(__('total entries')); ?>)",
                "infoPostFix":    "",
                "thousands":      ",",
                "lengthMenu":     "<?php echo e(__('Show')); ?> _MENU_ <?php echo e(__('entries')); ?>",
                "loadingRecords": "<?php echo e(__('Loading...')); ?>",
                "processing":     "",
                "search":         "<?php echo e(__('Search')); ?>:",
                "zeroRecords":    "<?php echo e(__('No matching records found')); ?>",
                "paginate": {
                    "first":      "<?php echo e(__('First')); ?>",
                    "last":       "<?php echo e(__('Last')); ?>",
                    "next":       '<?php echo e(__('Next')); ?> &#8250;',
                    "previous":   '&#8249; <?php echo e(__('Previous')); ?>'
                },
                "aria": {
                    "sortAscending":  ": activate to sort column ascending",
                    "sortDescending": ": activate to sort column descending"
                }
            },
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master',['menu'=>'setting', 'sub_menu'=>'currency_list'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/tradexpro-admin/resources/views/admin/currency/list.blade.php ENDPATH**/ ?>