<div class="header-bar">
    <div class="table-title">
        <h3><?php echo e(__('Coin Payment Details')); ?></h3>
    </div>
</div>
<div class="profile-info-form">
    <form action="<?php echo e(route('adminSavePaymentSettings')); ?>" method="post"
          enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="row">
            <div class="col-lg-6 col-12 mt-20">
                <div class="form-group">
                    <label for="#"><?php echo e(__('COIN PAYMENT PUBLIC KEY')); ?></label>
                    <?php if(env('APP_MODE') == 'demo'): ?>
                        <input class="form-control" value="<?php echo e('disablefordemo'); ?>">
                    <?php else: ?>
                        <input class="form-control" type="text" name="COIN_PAYMENT_PUBLIC_KEY"
                               autocomplete="off" placeholder=""
                               value="<?php echo e($settings['COIN_PAYMENT_PUBLIC_KEY'] ?? ''); ?>">
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-lg-6 col-12 mt-20">
                <div class="form-group">
                    <label for="#"><?php echo e(__('COIN PAYMENT PRIVATE KEY')); ?></label>
                    <?php if(env('APP_MODE') == 'demo'): ?>
                        <input class="form-control" value="<?php echo e('disablefordemo'); ?>">
                    <?php else: ?>
                        <input class="form-control" type="text" name="COIN_PAYMENT_PRIVATE_KEY"
                               autocomplete="off" placeholder=""
                               value="<?php echo e($settings['COIN_PAYMENT_PRIVATE_KEY'] ?? ''); ?>">
                    <?php endif; ?>

                </div>
            </div>
            <div class="col-lg-6 col-12 mt-20">
                <div class="form-group">
                    <label for="#"><?php echo e(__('COIN PAYMENT IPN MERCHANT ID')); ?></label>
                    <?php if(env('APP_MODE') == 'demo'): ?>
                        <input class="form-control" value="<?php echo e('disablefordemo'); ?>">
                    <?php else: ?>
                        <input class="form-control" type="text" name="ipn_merchant_id"
                               autocomplete="off" placeholder=""
                               value="<?php echo e($settings['ipn_merchant_id'] ?? ''); ?>">
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-lg-6 col-12 mt-20">
                <div class="form-group">
                    <label for="#"><?php echo e(__('COIN PAYMENT IPN SECRET')); ?></label>
                    <?php if(env('APP_MODE') == 'demo'): ?>
                        <input class="form-control" value="<?php echo e('disablefordemo'); ?>">
                    <?php else: ?>
                        <input class="form-control" type="text" name="ipn_secret"
                               autocomplete="off" placeholder=""
                               value="<?php echo e($settings['ipn_secret'] ?? ''); ?>">
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-lg-6 col-12 mt-20">
                <div class="form-group">
                    <label for="#"><?php echo e(__('Withdrawal email verification enable / disable')); ?></label>
                    <div class="cp-select-area">
                        <select name="coin_payment_withdrawal_email" class="form-control">
                            <option <?php if(isset($settings['coin_payment_withdrawal_email']) && $settings['coin_payment_withdrawal_email'] == STATUS_ACTIVE): ?> selected <?php endif; ?> value="<?php echo e(STATUS_ACTIVE); ?>"><?php echo e(__("Yes")); ?></option>
                            <option <?php if(isset($settings['coin_payment_withdrawal_email']) && $settings['coin_payment_withdrawal_email'] == STATUS_PENDING): ?> selected <?php endif; ?> value="<?php echo e(STATUS_PENDING); ?>"><?php echo e(__("No")); ?></option>
                        </select>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-2 col-12 mt-20">
                <button type="submit" class="button-primary theme-btn"><?php echo e(__('Update')); ?></button>
            </div>
        </div>
    </form>
</div>

<div class="user-management pt-4">
    <div class="row">
        <div class="col-12">
            <div class="header-bar">
                <div class="table-title">
                     <h3><?php echo e(__('CoinPayment Network Records')); ?></h3>
                </div>
                <div class="right d-flex align-items-center">
                    <div class="add-btn-new mb-2 mr-1">
                        <button id="sync_fees" class="float-right btn btn-primary"><?php echo e(__("Sync form CoinPayment")); ?></button>
                    </div>
                </div>
            </div>
            <div class="table-area">
                <div class="table-responsive">
                    <table id="withdrawTable" class=" table table-borderless custom-table display text-lg-center" width="100%">
                        <thead>
                        <tr>
                            <th class="all"><?php echo e(__('Coin type')); ?></th>
                            <th class="desktop"><?php echo e(__('BTC rate')); ?></th>
                            <th class="desktop"><?php echo e(__('Tx rate')); ?></th>
                            <th class="desktop"><?php echo e(__('Is fiat')); ?></th>
                            <th class="desktop"><?php echo e(__('status')); ?></th>
                            <th class="desktop"><?php echo e(__('Last Update')); ?></th>
                        </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /var/www/html/tradexpro-admin/resources/views/admin/settings/api/coin_payment.blade.php ENDPATH**/ ?>