<?php $__env->startSection('title', isset($title) ? $title : ''); ?>
<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- breadcrumb -->
    <div class="custom-breadcrumb">
        <div class="row">
            <div class="col-12">
                <ul>
                    <li><?php echo e(__('Fiat Deposit')); ?></li>
                    <li class="active-item"><?php echo e($title); ?></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- /breadcrumb -->

    <!-- User Management -->
    <div class="user-management">
        <div class="row">
            <div class="col-12">
                <div class="profile-info-form">
                    <div class="card-body">
                        <form action="<?php echo e(route('bankStore')); ?>" method="post">
                            <?php echo csrf_field(); ?>

                            <?php if(isset($item)): ?>
                                <input type="hidden" name="id" value="<?php echo e($item->id); ?>">
                            <?php endif; ?>
                            <div class="row">
                                <div class="col-md-6 mt-20">
                                    <div class="form-group">
                                        <label for="account_holder_name"><?php echo e(__('Account Holder Name')); ?></label>
                                        <input type="text" name="account_holder_name" class="form-control" id="account_holder_name" placeholder="<?php echo e(__('Account Holder Name')); ?>"
                                               <?php if(isset($item)): ?> value="<?php echo e($item->account_holder_name); ?>" <?php else: ?> value="<?php echo e(old('account_holder_name')); ?>" <?php endif; ?>>
                                        <span class="text-danger"><strong><?php echo e($errors->first('account_holder_address')); ?></strong></span>
                                    </div>
                                </div>

                                <div class="col-md-6 mt-20">
                                    <div class="form-group">
                                        <label for="account_holder_address"><?php echo e(__('Account Holder Address')); ?></label>
                                        <input type="text" name="account_holder_address" class="form-control" id="account_holder_address" placeholder="<?php echo e(__('Account Holder Address')); ?>"
                                               <?php if(isset($item)): ?> value="<?php echo e($item->account_holder_address); ?>" <?php else: ?> value="<?php echo e(old('account_holder_address')); ?>" <?php endif; ?>>
                                        <span class="text-danger"><strong><?php echo e($errors->first('account_holder_address')); ?></strong></span>
                                    </div>
                                </div>
                                <div class="col-md-6 mt-20">
                                    <div class="form-group">
                                        <label for="bank_name"><?php echo e(__('Bank Name')); ?></label>
                                        <input type="text" name="bank_name" class="form-control" id="bank_name" placeholder="<?php echo e(__('Bank Name')); ?>"
                                               <?php if(isset($item)): ?> value="<?php echo e($item->bank_name); ?>" <?php else: ?> value="<?php echo e(old('bank_name')); ?>" <?php endif; ?>>
                                        <span class="text-danger"><strong><?php echo e($errors->first('bank_name')); ?></strong></span>
                                    </div>
                                </div>
                                <div class="col-md-6 mt-20">
                                    <div class="form-group">
                                        <label for="bank_address"><?php echo e(__('Bank Address')); ?></label>
                                        <input type="text" name="bank_address" class="form-control" id="bank_address" placeholder="<?php echo e(__('Bank Address')); ?>"
                                               <?php if(isset($item)): ?> value="<?php echo e($item->bank_address); ?>" <?php else: ?> value="<?php echo e(old('bank_address')); ?>" <?php endif; ?>>
                                        <span class="text-danger"><strong><?php echo e($errors->first('bank_address')); ?></strong></span>
                                    </div>
                                </div>
                                <div class="col-md-6 mt-20">
                                    <label for="country"><?php echo e(__('Country')); ?></label>
                                    <div class="cp-select-area customSelect ">
                                        <select name="country_code" id="country_code" class="selectpicker" title="<?php echo e(__('Select Country')); ?>" data-live-search="true" data-width="100%"
                                            data-style="btn-info" data-actions-box="true" data-selected-text-format="count > 4">
                                        <?php if(isset($countries)): ?>
                                            <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($country->key); ?>"
                                                <?php if(isset($item)): ?> <?php echo e($country->key == $item->country ? 'selected' :' '); ?>

                                                <?php endif; ?> ><?php echo e($country->value); ?> </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6 mt-20">
                                    <div class="form-group">
                                        <label for="swift_code"><?php echo e(__('Swift Code')); ?></label>
                                        <input type="text" name="swift_code" class="form-control" id="swift_code" placeholder="<?php echo e(__('Swift Code')); ?>"
                                               <?php if(isset($item)): ?> value="<?php echo e($item->swift_code); ?>" <?php else: ?> value="<?php echo e(old('swift_code')); ?>" <?php endif; ?>>
                                        <span class="text-danger"><strong><?php echo e($errors->first('swift_code')); ?></strong></span>
                                    </div>
                                </div>
                                <div class="col-md-6 mt-20">
                                    <div class="form-group">
                                        <label for="iban"><?php echo e(__('Iban')); ?></label>
                                        <input type="text" name="iban" class="form-control" id="iban" placeholder="<?php echo e(__('Iban')); ?>"
                                               <?php if(isset($item)): ?> value="<?php echo e($item->iban); ?>" <?php else: ?> value="<?php echo e(old('iban')); ?>" <?php endif; ?>>
                                        <span class="text-danger"><strong><?php echo e($errors->first('iban')); ?></strong></span>
                                    </div>
                                </div>
                                <div class="col-md-6 mt-20">
                                    <div class="form-group">
                                        <label for="note"><?php echo e(__('Note')); ?></label>
                                        <input type="text" name="note" class="form-control" id="note" placeholder="<?php echo e(__('Note')); ?>"
                                               <?php if(isset($item)): ?> value="<?php echo e($item->note); ?>" <?php else: ?> value="<?php echo e(old('note')); ?>" <?php endif; ?>>
                                        <span class="text-danger"><strong><?php echo e($errors->first('note')); ?></strong></span>
                                    </div>
                                </div>
                                <div class="col-md-6 mt-20">
                                    <div class="form-group">
                                        <label class="switch" style="width: 150px;height: 42px;">
                                            <input <?php echo e(isset($item) && $item->status ? 'checked' : ''); ?> type="checkbox" name="status">
                                            <span class="slider round"></span>
                                        </label>
                                    </div>
                                </div>
                                <?php if(isset($item)): ?>
                                    <input type="hidden" name="id" value="<?php echo e($item->id); ?>">
                                <?php endif; ?>
                                <div class="col-md-12">
                                    <?php if(isset($item)): ?>
                                        <input type="hidden" name="edit_id" value="<?php echo e($item->id); ?>">
                                    <?php endif; ?>
                                    <button class="button-primary theme-btn"><?php if(isset($item)): ?> <?php echo e(__('Update')); ?> <?php else: ?> <?php echo e(__('Save')); ?> <?php endif; ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /User Management -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master',['menu'=>'currency_deposit', 'sub_menu'=>'currency_list'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/tradexpro-admin/resources/views/admin/bank/addEdit.blade.php ENDPATH**/ ?>