<?php $__env->startSection('title', isset($title) ? $title : ''); ?>
<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- breadcrumb -->
    <div class="custom-breadcrumb">
        <div class="row">
            <div class="col-md-9">
                <ul>
                    <li><?php echo e(__('Coin')); ?></li>
                    <li class="active-item"><?php echo e($title); ?></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- /breadcrumb -->
    <?php
        $demoTrade = (isset($module) && isset($module['DemoTrade'])) ? true : false ;
    ?>
    <!-- User Management -->
    <div class="user-management pt-4">
        <div class="row">
            <div class="col-12">
                <div class="header-bar">
                    <div class="table-title">
                        <!-- <h3><?php echo e($title); ?></h3> -->
                    </div>
                    <div class="right d-flex align-items-center">
                        <div class="add-btn-new mb-2 mr-1">
                            <a href="<?php echo e(route('adminCoinRate')); ?>"><?php echo e(__('Update Coin Rate')); ?></a>
                        </div>
                        <div class="add-btn-new mb-2 ml-2">
                            <a href="<?php echo e(route('adminAddCoin')); ?>"><?php echo e(__('Add New Coin')); ?></a>
                        </div>
                    </div>
                </div>
                <div class="table-area">
                    <div class="table-responsive">
                        <table id="table" class=" table table-borderless custom-table display text-lg-center" width="100%">
                            <thead>
                            <tr>
                                <th scope="col" ><?php echo e(__('Coin Name')); ?></th>
                                <th scope="col" class="all"><?php echo e(__('Currency Type')); ?></th>
                                <th scope="col"><?php echo e(__('Coin Type')); ?></th>
                                <th scope="col"><?php echo e(__('Coin API')); ?></th>
                                <th scope="col"><?php echo e(__('Coin Price')); ?></th>
                                <th scope="col" class="all"><?php echo e(__('Status')); ?></th>
                                <?php if($demoTrade): ?>
                                    <th scope="col" class="all"><?php echo e(__('Demo Trade')); ?></th>
                                <?php endif; ?>
                                <th scope="col"><?php echo e(__('Updated At')); ?></th>
                                <th scope="col" class="all"><?php echo e(__('Actions')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php if(isset($coins)): ?>
                            <?php $__currentLoopData = $coins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td> <?php echo e($coin->name); ?> </td>
                                    <td> <?php echo e(getTradeCurrencyType($coin->currency_type)); ?> </td>
                                    <td> <?php echo e(find_coin_type($coin->coin_type)); ?> </td>
                                    <td> <?php echo e($coin->currency_type == CURRENCY_TYPE_CRYPTO ? api_settings($coin->network) : __("Fiat Currency")); ?> </td>
                                    <td> <?php echo e(number_format($coin->coin_price,2).' USD/ '.find_coin_type($coin->coin_type)); ?> </td>
                                    <td>
                                        <?php if($coin->ico_id == 0 || $coin->is_listed == 1): ?>
                                            <div>
                                                <label class="switch">
                                                    <input type="checkbox" onclick="return processForm('<?php echo e($coin->id); ?>')"
                                                        id="notification" name="security" <?php if($coin->status == STATUS_ACTIVE): ?> checked <?php endif; ?>>
                                                    <span class="slider" for="status"></span>
                                                </label>
                                            </div>
                                        <?php else: ?>
                                            <button class="btn-sm btn-warning" data-toggle="tooltip" data-placement="top" title="<?php echo e(__('You can  not change the status of this coin')); ?>"><?php echo e(__('Disable')); ?></button>
                                        <?php endif; ?>
                                    </td>
                                    <?php if($demoTrade): ?>
                                        <td>
                                            <div>
                                                <label class="switch">
                                                    <input type="checkbox" onclick="changeDemoTradeStatus('<?php echo e($coin->coin_type); ?>')"
                                                        id="notification" name="security" <?php if($coin->is_demo_trade == STATUS_ACTIVE): ?> checked <?php endif; ?>>
                                                    <span class="slider" for="status"></span>
                                                </label>
                                            </div>
                                        </td>
                                    <?php endif; ?>
                                    <td> <?php echo e($coin->updated_at); ?></td>
                                    <td>
                                        <?php if($coin->ico_id == 0 || $coin->is_listed == 1): ?>
                                            <ul class="d-flex activity-menu">
                                                <li class="viewuser">
                                                    <a href="<?php echo e(route('adminCoinEdit', encrypt($coin->id))); ?>" title="<?php echo e(__("Update")); ?>" class="btn btn-primary btn-sm">
                                                        <i class="fa fa-pencil"></i>
                                                    </a>
                                                </li>
                                                <?php if($coin->currency_type == CURRENCY_TYPE_CRYPTO): ?>
                                                    <li class="viewuser">
                                                        <a href="<?php echo e(route('adminCoinSettings', encrypt($coin->id))); ?>" title="<?php echo e(__("Settings")); ?>" class="btn btn-warning btn-sm">
                                                            <i class="fa fa-cog"></i>
                                                        </a>
                                                    </li>
                                                <?php endif; ?>
                                                <li class="viewuser">
                                                    <a href="#delete1WV4d6uF6Ytu8v1Pl_<?php echo e(($coin->id)); ?>" data-toggle="modal" title="<?php echo e(__("Delete")); ?>" class="btn btn-danger btn-sm">
                                                        <i class="fa fa-trash"></i>
                                                    </a>
                                                    <div id="delete1WV4d6uF6Ytu8v1Pl_<?php echo e(($coin->id)); ?>" class="modal fade delete" role="dialog">
                                                        <div class="modal-dialog modal-sm">
                                                            <div class="modal-content">
                                                                <div class="modal-header"><h6 class="modal-title"><?php echo e(__('Delete')); ?></h6><button type="button" class="close" data-dismiss="modal">&times;</button></div>
                                                                <div class="modal-body"><p><?php echo e(__('Do you want to delete ?')); ?></p></div>
                                                                <div class="modal-footer"><button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(__("Close")); ?></button>
                                                                    <a class="btn btn-danger"href="<?php echo e(route('adminCoinDelete', encrypt($coin->id))); ?>"><?php echo e(__('Confirm')); ?> </a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                            </ul>
                                        <?php else: ?>

                                            <ul class="d-flex activity-menu">
                                                <li class="viewuser">
                                                    <a href="#make_listed_coin_<?php echo e(($coin->id)); ?>" data-toggle="modal" title="<?php echo e(__("Make Listed")); ?>" class="btn btn-danger btn-sm">
                                                        <?php echo e(__('Make Listed')); ?>

                                                    </a>
                                                    <div id="make_listed_coin_<?php echo e(($coin->id)); ?>" class="modal fade delete" role="dialog">
                                                        <div class="modal-dialog modal-md">
                                                            <div class="modal-content">
                                                                <div class="modal-header">
                                                                    <h6 class="modal-title"><?php echo e(__('Make Listed')); ?></h6>
                                                                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                                </div>
                                                                <div class="modal-body">
                                                                    <ul>
                                                                        <li><?php echo e(__('1')); ?>.<?php echo e(__('Check your Token Buy history for this token. If any request is pending for this token then make it rejected or accepted. Otherwise this token is not listed.')); ?></li>
                                                                        <li><?php echo e(__('2')); ?>.<?php echo e(__('Check your Phases for this token. If any phase is running make it deactive or it will automatically deactive. ')); ?></li>
                                                                        <li><?php echo e(__('3')); ?>.<?php echo e(__('After make it listed you can not create new phase or run any phase for this token.')); ?></li>
                                                                    </ul>
                                                                </div>
                                                                <div class="modal-footer"><button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(__("Close")); ?></button>
                                                                    <a class="btn btn-danger"href="<?php echo e(route('coinMakeListed', encrypt($coin->id))); ?>"><?php echo e(__('Confirm')); ?> </a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                            <ul>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /User Management -->

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('#table').DataTable({
                responsive: true,
                paging: true,
                searching: true,
                ordering:  true,
                select: false,
                bDestroy: true
            });
        })(jQuery);
        function processForm (active_id) {
            $.ajax({
                type: "POST",
                url: "<?php echo e(route('adminCoinStatus')); ?>",
                data: {
                    '_token': "<?php echo e(csrf_token()); ?>",
                    'active_id': active_id
                },
                success: function (data) {
                    console.log(data);
                }
            });
        }
        <?php if($demoTrade): ?>
            function changeDemoTradeStatus($coin){
                let url = '<?php echo e(route("demoTradeCoinStatus")); ?>'+$coin;
                $.get(url,(data)=>{
                    if(data?.success) {
                        VanillaToasts.create({
                            text: data?.message,
                            type: 'success',
                            timeout: 40000
                        }); return;
                    }
                    VanillaToasts.create({
                        text: data?.message,
                        type: 'warning',
                        timeout: 40000
                    });
                });
            }
        <?php endif; ?>
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master',['menu'=>'coin', 'sub_menu' => 'coin_list'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/tradexpro-admin/resources/views/admin/coin-order/coin.blade.php ENDPATH**/ ?>