<?php $__env->startSection('title', isset($title) ? $title : ''); ?>
<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- breadcrumb -->
    <div class="custom-breadcrumb">
        <div class="row">
            <div class="col-12">
                <ul>
                    <li><?php echo e(__('Wallet Management')); ?></li>
                    <li class="active-item"><?php echo e(__('User Wallet List')); ?></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- /breadcrumb -->

    <!-- User Management -->
    <div class="user-management pt-4">
        <div class="row">
            <div class="col-12">
                <div class="table-area">
                    <div class="table-responsive">
                        <div class="">
                            <form id="withdrawal_form" class="row" action="<?php echo e(route('adminWalletListExport')); ?>" method="get">
                                <?php echo csrf_field(); ?>
                                <div class="col-3 form-group">
                                    <label for="#"><?php echo e(__('From Date')); ?></label>
                                    <input type="hidden" name="type" value="withdrawal" />
                                    <input type="date" name="from_date" class="form-control" />
                                </div>
                                <div class="col-3 form-group">
                                    <label for="#"><?php echo e(__('To Date')); ?></label>
                                    <input type="date" name="to_date" class="form-control" />
                                </div>
                                <div class="col-3 form-group">
                                    <label for="#"><?php echo e(__('Export')); ?></label>
                                    <select name="export_to" class="selectpicker" data-style="form-control" data-width="100%" title="<?php echo e(__('Select a file type')); ?>" >
                                        <option value=".csv">CSV</option>
                                        <option value=".xlsx">XLSX</option>
                                    </select>
                                </div>
                                <div class="col-3 form-group">
                                    <label for="#">&nbsp;</label>
                                    <input class="form-control btn btn-primary" style="background-color:#1d2124" type="submit" value="<?php echo e(__("Export")); ?>" />
                                </div>
                            </form>
                        </div>
                        <table id="table" class="table table-borderless custom-table display text-lg-center" width="100%">
                            <thead>
                            <tr>
                                <th class="all"><?php echo e(__('Wallet Name')); ?></th>
                                <th class="all"><?php echo e(__('Coin Type')); ?></th>
                                <th><?php echo e(__('User Name')); ?></th>
                                <th><?php echo e(__('User Email')); ?></th>
                                <th><?php echo e(__('Balance')); ?></th>
                                <th><?php echo e(__('Date')); ?></th>
                                <th><?php echo e(__('Action')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /User Management -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('#table').DataTable({
                processing: true,
                serverSide: true,
                pageLength: 10,
                bLengthChange: true,
                responsive: true,
                ajax: '<?php echo e(route('adminWalletList')); ?>',
                order: [5, 'desc'],
                autoWidth: false,
                language: {
                    paginate: {
                        next: 'Next &#8250;',
                        previous: '&#8249; Previous'
                    }
                },
                columns: [
                    {"data": "name"},
                    {"data": "coin_type"},
                    {"data": "user_name"},
                    {"data": "email", name: 'users.email'},
                    {"data": "balance"},
                    {"data": "created_at"},
                    {"data": "actions"}
                ]
            });
        })(jQuery)
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master',['menu'=>'wallet'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/tradexpro-admin/resources/views/admin/wallet/index.blade.php ENDPATH**/ ?>