<!DOCTYPE HTML>
<html class="no-js" lang="en">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta property="og:type" content="article" />
    <meta property="og:image" content="<?php echo e(landingPageImage('logo','images/logo.svg')); ?>">
    <meta property="og:site_name" content="<?php echo e(allsetting('app_title')); ?>"/>
    <meta property="og:url" content="<?php echo e(url()->current()); ?>"/>
    <meta itemprop="image" content="<?php echo e(landingPageImage('logo','images/logo.svg')); ?>" />
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/common/css/bootstrap.min.css')); ?>">
    <!-- metismenu CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/common/css/metisMenu.min.css')); ?>">
    <!-- fontawesome CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/common/css/font-awesome.min.css')); ?>">
    
    <link href="<?php echo e(asset('assets/common/toast/vanillatoasts.css')); ?>" rel="stylesheet" >

    <?php echo NoCaptcha::renderJs(); ?>


    <!-- Style CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/style.css')); ?>">
    <!-- Responsive CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/responsive.css')); ?>">
    <?php echo $__env->yieldContent('style'); ?>
    <title><?php echo $__env->yieldContent('title'); ?> :: <?php echo e(settings('app_title')); ?></title>
    <!-- Favicon and Touch Icons -->
    <link rel="shortcut icon" href="<?php echo e(landingPageImage('favicon','images/fav.png')); ?>/">
</head>

<body>

    <?php echo $__env->yieldContent('content'); ?>

<!-- js file start -->

<!-- JavaScript -->
<script src="<?php echo e(asset('assets/common/js/jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/common/js/popper.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/common/js/bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/common/js/metisMenu.min.js')); ?>"></script>

<script src="<?php echo e(asset('assets/common/toast/vanillatoasts.js')); ?>"></script>

<script src="<?php echo e(asset('assets/admin/js/main.js')); ?>"></script>

<script>
    (function($) {
            "use strict";
            <?php if(session()->has('success')): ?>

                window.onload = function () {
                VanillaToasts.create({
                    text: '<?php echo e(session('success')); ?>',
                    backgroundColor: "linear-gradient(135deg, #73a5ff, #5477f5)",
                    type: 'success',
                    timeout: 10000
                });
            };

            <?php elseif(session()->has('dismiss')): ?>

                window.onload = function () {

                VanillaToasts.create({
                    text: '<?php echo e(session('dismiss')); ?>',
                    type: 'warning',
                    timeout: 10000

                });
            };

            <?php elseif($errors->any()): ?>
                <?php $__currentLoopData = $errors->getMessages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                window.onload = function () {
                VanillaToasts.create({
                    text: '<?php echo e($error[0]); ?>',
                    type: 'warning',
                    timeout: 10000

                     });
                };
                <?php break; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>

        })(jQuery)

</script>
<?php echo $__env->yieldContent('script'); ?>
<!-- End js file -->
</body>
</html>

<?php /**PATH /var/www/html/tradexpro-admin/resources/views/auth/master.blade.php ENDPATH**/ ?>