<?php $__env->startSection('title', isset($title) ? $title : ''); ?>
<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- breadcrumb -->
    <div class="custom-breadcrumb">
        <div class="row">
            <div class="col-12">
                <ul>
                    <li><?php echo e(__('Transaction History')); ?> </li>
                    <li class="active-item"><?php echo e(__('Pending Deposit')); ?></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- /breadcrumb -->

    <!-- User Management -->
    <div class="user-management wallet-transaction-area">
        <div class="row no-gutters">
            <div class="col-12">
                <div class="table-area">
                    <div class="table-responsive">
                            <div class="">
                                <form id="deposit_form" class="row" action="<?php echo e(route('adminTransactionHistoryExport')); ?>" method="get">
                                    <?php echo csrf_field(); ?>
                                    <div class="col-3 form-group">
                                        <label for="#"><?php echo e(__('From Date')); ?></label>
                                        <input type="hidden" name="type" value="pending_deposit" />
                                        <input type="date" name="from_date" class="form-control" />
                                    </div>
                                    <div class="col-3 form-group">
                                        <label for="#"><?php echo e(__('To Date')); ?></label>
                                        <input type="date" name="to_date" class="form-control" />
                                    </div>
                                    <div class="col-3 form-group">
                                        <label for="#"><?php echo e(__('Export')); ?></label>
                                        <select name="export_to" class="selectpicker" data-style="form-control" data-width="100%" title="<?php echo e(__('Select a file type')); ?>">
                                            <option value=".csv">CSV</option>
                                            <option value=".xlsx">XLSX</option>
                                        </select>
                                    </div>
                                    <div class="col-3 form-group">
                                            <label for="#">&nbsp;</label>
                                            <input class="form-control btn btn-primary" style="background-color:#1d2124" type="submit" value="<?php echo e(__("Export")); ?>" />
                                    </div>
                                </form>
                            </div>
                        <table id="table" class="table table-borderless custom-table display text-left"
                               width="100%">
                            <thead>
                            <tr>
                                <th><?php echo e(__('User')); ?></th>
                                <th class="all"><?php echo e(__('Address')); ?></th>
                                <th><?php echo e(__('From Address')); ?></th>
                                <th><?php echo e(__('Coin Type')); ?></th>
                                <th><?php echo e(__('Coin API')); ?></th>
                                <th class="all"><?php echo e(__('Amount')); ?></th>
                                <th ><?php echo e(__('Transaction Id')); ?></th>
                                <th><?php echo e(__('Date')); ?></th>
                                <th class="all"><?php echo e(__('Actions')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /User Management -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        (function($) {
            "use strict";

            $('#table').DataTable({
                processing: true,
                serverSide: true,
                pageLength: 10,
                responsive: true,
                ajax: '<?php echo e(route('adminPendingDeposit')); ?>',
                order: [6, 'desc'],
                autoWidth: false,
                language: {
                    paginate: {
                        next: 'Next &#8250;',
                        previous: '&#8249; Previous'
                    }
                },
                columns: [
                    {"data": "receiver_wallet_id"},
                    {"data": "address"},
                    {"data": "from_address"},
                    {"data": "coin_type"},
                    {"data": "network_type"},
                    {"data": "amount"},
                    {"data": "transaction_id"},
                    {"data": "created_at"},
                    {"data": "actions"}
                ]
            });
        })(jQuery);
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master',['menu'=>'transaction', 'sub_menu'=>'transaction_deposit'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/tradexpro-admin/resources/views/admin/transaction/pending-deposit.blade.php ENDPATH**/ ?>