<div class="header-bar">
    <div class="table-title">
        <h3><?php echo e(__('General Settings')); ?></h3>
    </div>
</div>
<div class="profile-info-form">
    <form action="<?php echo e(route('adminCommonSettings')); ?>" method="post" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="row">
            <div class="col-lg-6 col-12  mt-20">
                <div class="form-group">
                    <label for="#"><?php echo e(__('Application Frontend URL')); ?> (Example: https://exchange.com)</label>
                    <input class="form-control" type="text" name="exchange_url"
                           placeholder="<?php echo e(__('Url where user show the exchange page')); ?>"
                           value="<?php echo e($settings['exchange_url'] ?? ''); ?>">
                </div>
            </div>
            <div class="col-lg-6 col-12 mt-20">
                <div class="form-group">
                    <label><?php echo e(__('Language')); ?></label>
                    <div class="cp-select-area">
                        <select name="lang" class="form-control">
                            <?php if(isset($languages[0])): ?>
                                <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option
                                        <?php if(isset($settings['lang']) && $settings['lang']==$val->key): ?> selected
                                        <?php endif; ?> value="<?php echo e($val->key); ?>"><?php echo e($val->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </select>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 col-12  mt-20">
                <div class="form-group">
                    <label for="#"><?php echo e(__('Company Name')); ?></label>
                    <input class="form-control" type="text" name="company_name"
                           placeholder="<?php echo e(__('Company Name')); ?>"
                           value="<?php echo e($settings['app_title']); ?>">
                </div>
            </div>
            <div class="col-lg-6 col-12  mt-20">
                <div class="form-group">
                    <label for="#"><?php echo e(__(' Base Coin Type')); ?></label>
                    <input class="form-control" type="text" name="base_coin_type"
                           placeholder="<?php echo e(__('Coin Type eg. BTC')); ?>"
                           value="<?php echo e(isset($settings['base_coin_type']) ? $settings['base_coin_type'] : ''); ?>">
                </div>
            </div>
            <div class="col-lg-6 col-12  mt-20">
                <div class="form-group">
                    <label for="#"><?php echo e(__('Copyright Text')); ?></label>
                    <input class="form-control" type="text" name="copyright_text"
                           placeholder="<?php echo e(__('Copyright Text')); ?>"
                           value="<?php echo e($settings['copyright_text']); ?>">
                </div>
            </div>

            <div class="col-lg-6 col-12 mt-20">
                <div class="form-group">
                    <label
                        for="#"><?php echo e(__('Number of confirmation for Notifier deposit')); ?> </label>
                    <input class="form-control number_only" type="text"
                           name="number_of_confirmation" placeholder=""
                           value="<?php echo e($settings['number_of_confirmation']); ?>">
                </div>
            </div>
            <div class="col-lg-6 col-12 mt-20">
                <div class="form-group">
                    <label
                        for="#"><?php echo e(__('Trading price tolerance')); ?> </label>
                    <input class="form-control number_only" type="text"
                           name="trading_price_tolerance" placeholder=""
                           value="<?php echo e($settings['trading_price_tolerance'] ?? 10); ?>">
                </div>
            </div>
        </div>
        <div class="uplode-img-list">
            <div class="row">
                <div class="col-lg-4 mt-20">
                    <div class="single-uplode">
                        <div class="uplode-catagory">
                            <span><?php echo e(__('Logo')); ?></span>
                        </div>
                        <div class="form-group buy_coin_address_input ">
                            <div id="file-upload" class="section-p">
                                <input type="file" placeholder="0.00" name="logo" value=""
                                       id="file" ref="file" class="dropify"
                                       <?php if(isset($settings['logo']) && (!empty($settings['logo']))): ?>  data-default-file="<?php echo e(asset(path_image().$settings['logo'])); ?>" <?php endif; ?> />
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 mt-20">
                    <div class="single-uplode">
                        <div class="uplode-catagory">
                            <span><?php echo e(__('Login Background')); ?></span>
                        </div>
                        <div class="form-group buy_coin_address_input ">
                            <div id="file-upload" class="section-p">
                                <input type="file" placeholder="0.00" name="login_logo" value=""
                                       id="file" ref="file" class="dropify"
                                       <?php if(isset($settings['login_logo']) && (!empty($settings['login_logo']))): ?>  data-default-file="<?php echo e(asset(path_image().$settings['login_logo'])); ?>" <?php endif; ?> />
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 mt-20">
                    <div class="single-uplode">
                        <div class="uplode-catagory">
                            <span><?php echo e(__('Favicon')); ?></span>
                        </div>
                        <div class="form-group buy_coin_address_input ">
                            <div id="file-upload" class="section-p">
                                <input type="file" placeholder="0.00" name="favicon" value=""
                                       id="file" ref="file" class="dropify"
                                       <?php if(isset($settings['favicon']) && (!empty($settings['favicon']))): ?>  data-default-file="<?php echo e(asset(path_image().$settings['favicon'])); ?>" <?php endif; ?> />
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <?php if(isset($itech)): ?>
                <input type="hidden" name="itech" value="<?php echo e($itech); ?>">
            <?php endif; ?>
            <div class="col-lg-2 col-12 mt-20">
                <button class="button-primary theme-btn"><?php echo e(__('Update')); ?></button>
            </div>
        </div>
    </form>
</div>
<?php /**PATH /var/www/html/tradexpro-admin/resources/views/admin/settings/setting/general.blade.php ENDPATH**/ ?>