<?php $__env->startSection('title', isset($title) ? $title : ''); ?>
<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- breadcrumb -->
    <div class="custom-breadcrumb">
        <div class="row">
            <div class="col-12">
                <ul>
                    <li><?php echo e(__('Settings')); ?></li>
                    <li class="active-item"><?php echo e($title); ?></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- /breadcrumb -->

    <!-- User Management -->
    <div class="user-management pt-4">
        <div class="row no-gutters">
            <div class="col-12 col-lg-3 col-xl-2">
                <ul class="nav user-management-nav mb-3" id="pills-tab" role="tablist">
                    <li class="nav-item">
                        <a class="<?php if(isset($tab) && $tab=='payment'): ?> active <?php endif; ?> nav-link " id="pills-email-tab"
                           data-toggle="pill" data-controls="payment" href="#payment" role="tab"
                           aria-controls="pills-email" aria-selected="true">
                            <span><?php echo e(__('Coin Payment Settings')); ?></span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="<?php if(isset($tab) && $tab=='bitgo'): ?> active <?php endif; ?> nav-link " id="pills-email-tab"
                           data-toggle="pill" data-controls="bitgo" href="#bitgo" role="tab"
                           aria-controls="pills-email" aria-selected="true">
                            <span><?php echo e(__('Bitgo Settings')); ?></span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="<?php if(isset($tab) && $tab=='erc20'): ?> active <?php endif; ?> nav-link " id="pills-email-tab"
                           data-toggle="pill" data-controls="erc20" href="#erc20" role="tab"
                           aria-controls="pills-email" aria-selected="true">
                            <span><?php echo e(__('ERC20/BEP20/TRC20 Settings')); ?></span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="<?php if(isset($tab) && $tab=='crypto'): ?> active <?php endif; ?> nav-link " id="pills-email-tab"
                           data-toggle="pill" data-controls="crypto" href="#crypto" role="tab"
                           aria-controls="pills-email" aria-selected="true">
                            <span><?php echo e(__('CryptoCompare Api Settings')); ?></span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="<?php if(isset($tab) && $tab=='stripe'): ?> active <?php endif; ?> nav-link " id="pills-email-tab"
                           data-toggle="pill" data-controls="stripe" href="#stripe" role="tab"
                           aria-controls="pills-email" aria-selected="true">
                            <span><?php echo e(__('Stripe Settings')); ?></span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="<?php if(isset($tab) && $tab=='paystack'): ?> active <?php endif; ?> nav-link " id="pills-email-tab"
                           data-toggle="pill" data-controls="paystack" href="#paystack" role="tab"
                           aria-controls="pills-email" aria-selected="true">
                            <span><?php echo e(__('PayStack Settings')); ?></span>
                        </a>
                    </li>
                    
                </ul>
            </div>
            <div class="col-12 col-lg-9 col-xl-10">
                <div class="tab-content" id="pills-tabContent">
                    <div class="tab-pane <?php if(isset($tab) && $tab=='payment'): ?> show active <?php endif; ?>" id="payment"
                         role="tabpanel" aria-labelledby="pills-email-tab">
                        <?php echo $__env->make('admin.settings.api.coin_payment', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="tab-pane <?php if(isset($tab) && $tab=='bitgo'): ?> show active <?php endif; ?>" id="bitgo"
                         role="tabpanel" aria-labelledby="pills-email-tab">
                        <?php echo $__env->make('admin.settings.api.bitgo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="tab-pane <?php if(isset($tab) && $tab=='erc20'): ?> show active <?php endif; ?>" id="erc20"
                         role="tabpanel" aria-labelledby="pills-email-tab">
                        <?php echo $__env->make('admin.settings.api.erc20_settings', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="tab-pane <?php if(isset($tab) && $tab=='crypto'): ?> show active <?php endif; ?>" id="crypto"
                         role="tabpanel" aria-labelledby="pills-email-tab">
                        <?php echo $__env->make('admin.settings.api.others', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="tab-pane <?php if(isset($tab) && $tab=='stripe'): ?> show active <?php endif; ?>" id="stripe"
                         role="tabpanel" aria-labelledby="pills-email-tab">
                        <?php echo $__env->make('admin.settings.api.stripe', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="tab-pane <?php if(isset($tab) && $tab=='paystack'): ?> show active <?php endif; ?>" id="paystack"
                         role="tabpanel" aria-labelledby="pills-email-tab">
                        <?php echo $__env->make('admin.settings.api.paystack', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    
                </div>
            </div>
        </div>
    </div>
    <!-- /User Management -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        (function ($) {
            "use strict";

            $('.nav-link').on('click', function () {
                $('.nav-link').removeClass('active');
                $(this).addClass('active');
                var str = '#' + $(this).data('controls');
                $('.tab-pane').removeClass('show active');
                $(str).addClass('show active');
            });


            $('#withdrawTable').DataTable({
                processing:true,
                serverSide:true,
                pageLength:10,
                bLengthChange:true,
                responsive: true,
                language: {
                    paginate: {
                        next: 'Next &#8250;',
                        previous: '&#8249; Previous'
                    }
                },
                ajax:'<?php echo e(route('networkFees')); ?>',
                order:[5,'desc'],
                autoWidth:false,
                columns:[
                    {"data":"coin_type",searchable:true},
                    {"data":"rate_btc",searchable:true},
                    {"data":"tx_fee",searchable:true},
                    {"data":"is_fiat",searchable:true},
                    {"data":"status",searchable:true},
                    {"data":"last_update",searchable:true},
                ]
            });


        })(jQuery);

        $(document).on('click','#sync_fees',function (){
            // swalConfirm("Do you really want to update network list ?").then(function (s) {
            //     if(s.value){
                   window.location.href = '<?php echo e(route('networkFeesUpdate')); ?>';
            //     }
            // })
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master',['menu'=>'setting', 'sub_menu'=>'api_settings'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/tradexpro-admin/resources/views/admin/settings/api/general.blade.php ENDPATH**/ ?>