<div class="header-bar">
    <div class="table-title">
        <h3><?php echo e(__('Enable SMS settings')); ?></h3>
    </div>
</div>
<div class="row">
    <div class="col-md-6">
        <div class="profile-info-form">
            <form action="<?php echo e(route('adminChooseSmsSettings')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div class="row">
                    <div class="col-12 mt-20">
                        <div class="form-group">
                            <label for="#"><?php echo e(__('SMS Gateway Type')); ?></label>
                            <div class="cp-select-area">
                                <select name="select_sms_type" class="form-control">
                                    <?php $__currentLoopData = smsTypeList(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sms_key=>$sms_name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($sms_key); ?>"
                                            <?php if(isset($settings['select_sms_type']) && $settings['select_sms_type'] == $sms_key): ?>
                                                selected
                                            <?php endif; ?>><?php echo e($sms_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-2 col-12 mt-20">
                        <button type="submit" class="button-primary theme-btn"><?php echo e(__('Update')); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <div class="col-md-6">
        <div class="profile-info-form">
            <form action="<?php echo e(route('adminSendTestSms')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div class="row">
                    <div class="col-12 mt-20">
                        <div class="form-group">
                            <label for="#"><?php echo e(__('Test SMS Send')); ?></label>
                            <input class="form-control" type="text" name="mobile" >
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-2 col-12 mt-20">
                        <button type="submit" class="button-primary theme-btn"><?php echo e(__('Send')); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="header-bar mt-3">
    <div class="table-title">
        <h3><?php echo e(__('Twillo Setup')); ?></h3>
    </div>
</div>
<div class="profile-info-form">
    <form action="<?php echo e(route('adminSaveSmsSettings')); ?>" method="post"
          enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="row">
            <div class="col-lg-6 col-12  mt-20">
                <div class="form-group">
                    <label for="#"><?php echo e(__('Twillo Secret Key')); ?></label>
                    <?php if(env('APP_MODE') == 'demo'): ?>
                        <input class="form-control" value="<?php echo e('disablefordemo'); ?>">
                    <?php else: ?>
                    <input class="form-control" type="text" name="twillo_secret_key"
                           placeholder="<?php echo e(__('Secret Key')); ?>"
                           value="<?php echo e($settings['twillo_secret_key']); ?>">
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-lg-6 col-12  mt-20">
                <div class="form-group">
                    <label for="#"><?php echo e(__('Auth Token')); ?></label>
                    <?php if(env('APP_MODE') == 'demo'): ?>
                        <input class="form-control" value="<?php echo e('disablefordemo'); ?>">
                    <?php else: ?>
                    <input class="form-control" type="text" name="twillo_auth_token"
                           placeholder="<?php echo e(__('Auth Token')); ?>"
                           value="<?php echo e($settings['twillo_auth_token']); ?>">
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-lg-6 col-12  mt-20">
                <div class="form-group">
                    <label for="#"><?php echo e(__('From Number')); ?></label>
                    <input class="form-control" type="text" name="twillo_number"
                           placeholder="<?php echo e(__('Number')); ?>"
                           value="<?php echo e(isset($settings['twillo_number']) ? $settings['twillo_number'] : ''); ?>">
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-2 col-12 mt-20">
                <button type="submit" class="button-primary theme-btn"><?php echo e(__('Update')); ?></button>
            </div>
        </div>
    </form>
</div>

<div class="header-bar mt-3">
    <div class="table-title">
        <h3><?php echo e(__('Vonage/Nexmo Setup')); ?></h3>
    </div>
</div>
<div class="profile-info-form">
    <form action="<?php echo e(route('adminNexmoSmsSettingsSave')); ?>" method="post"
          enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="row">
            <div class="col-lg-6 col-12  mt-20">
                <div class="form-group">
                    <label for="#"><?php echo e(__('Vonage/Nexmo Secret Key')); ?></label>
                    <?php if(env('APP_MODE') == 'demo'): ?>
                        <input class="form-control" value="<?php echo e('disablefordemo'); ?>">
                    <?php else: ?>
                    <input class="form-control" type="text" name="nexmo_secret_key"
                           placeholder="<?php echo e(__('Secret Key')); ?>"
                           value="<?php echo e($settings['nexmo_secret_key']); ?>">
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-lg-6 col-12  mt-20">
                <div class="form-group">
                    <label for="#"><?php echo e(__('Vonage/Nexmo API Key')); ?></label>
                    <?php if(env('APP_MODE') == 'demo'): ?>
                        <input class="form-control" value="<?php echo e('disablefordemo'); ?>">
                    <?php else: ?>
                    <input class="form-control" type="text" name="nexmo_api_key"
                           placeholder="<?php echo e(__('Vonage/Nexmo API Key')); ?>"
                           value="<?php echo e($settings['nexmo_api_key']); ?>">
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-2 col-12 mt-20">
                <button type="submit" class="button-primary theme-btn"><?php echo e(__('Update')); ?></button>
            </div>
        </div>
    </form>
</div>

<div class="header-bar mt-3">
    <div class="table-title">
        <h3><?php echo e(__("Africa's Talking Setup")); ?></h3>
    </div>
</div>
<div class="profile-info-form">
    <form action="<?php echo e(route('adminAfricaTalkSmsSettingsSave')); ?>" method="post"
          enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="row">
            <div class="col-lg-6 col-12  mt-20">
                <div class="form-group">
                    <label for="#"><?php echo e(__('Select Apps Mode')); ?></label>
                    <select name="africa_talk_app_mode" class="form-control">
                        <option value="sandbox"
                            <?php echo e($settings['africa_talk_app_mode'] == 'sandbox'?'selected':''); ?>><?php echo e(__('SandBox')); ?> </option>
                        <?php if(env('APP_MODE') != 'demo'): ?>
                            <option value="live"
                                <?php echo e($settings['africa_talk_app_mode'] == 'live'?'selected':''); ?>><?php echo e(__('Live')); ?> </option>
                        <?php endif; ?>
                    </select>
                </div>
            </div>
            <div class="col-lg-6 col-12  mt-20">
                <div class="form-group">
                    <label for="#"><?php echo e(__('Apps User Name')); ?></label>
                    <?php if(env('APP_MODE') == 'demo'): ?>
                        <input class="form-control" value="<?php echo e('disablefordemo'); ?>">
                    <?php else: ?>
                    <input class="form-control" type="text" name="africa_talk_user_name"
                           placeholder="<?php echo e(__('Secret Key')); ?>"
                           value="<?php echo e($settings['africa_talk_user_name']); ?>">
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-lg-6 col-12  mt-20">
                <div class="form-group">
                    <label for="#"><?php echo e(__('API Key')); ?></label>
                    <?php if(env('APP_MODE') == 'demo'): ?>
                        <input class="form-control" value="<?php echo e('disablefordemo'); ?>">
                    <?php else: ?>
                    <input class="form-control" type="text" name="africa_talk_api_key"
                           placeholder="<?php echo e(__('API Key')); ?>"
                           value="<?php echo e($settings['africa_talk_api_key']); ?>">
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-2 col-12 mt-20">
                <button type="submit" class="button-primary theme-btn"><?php echo e(__('Update')); ?></button>
            </div>
        </div>
    </form>
</div>
<?php /**PATH /var/www/html/tradexpro-admin/resources/views/admin/settings/setting/sms-settings.blade.php ENDPATH**/ ?>