<?php $__env->startSection('title', isset($title) ? $title : ''); ?>
<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- breadcrumb -->
    <div class="custom-breadcrumb">
        <div class="row">
            <div class="col-12">
                <ul>
                    <li><?php echo e(__('Wallet Management')); ?></li>
                    <li class="active-item"><?php echo e(__('User Wallet Address List')); ?></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- /breadcrumb -->

    <!-- User Management -->
    <div class="user-management pt-4">
        <div class="row">
            <div class="col-12">
                <div class="table-area">
                    <div class="table-responsive">
                        <table id="table" class="table table-borderless custom-table display text-lg-center" width="100%">
                            <thead>
                            <tr>
                                <th class="all"><?php echo e(__('Coin Type')); ?></th>
                                <th class="all"><?php echo e(__('Address')); ?></th>
                                <th><?php echo e(__('Date')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                                <?php if(isset($address_list[0])): ?>
                                    <?php $__currentLoopData = $address_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($item->coin_type); ?></td>
                                            <td><?php echo e($item->address); ?></td>
                                            <td><?php echo e($item->created_at); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>

                                <?php if(isset($address_network_list[0])): ?>
                                    <?php $__currentLoopData = $address_network_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($items->network_type); ?></td>
                                            <td><?php echo e($items->address); ?></td>
                                            <td><?php echo e($items->created_at); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /User Management -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('#table').DataTable({
                responsive: true,
                paging: true,
                searching: true,
                ordering:  true,
                select: false,
                bDestroy: true
            });
        })(jQuery)
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master',['menu'=>'wallet'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/tradexpro-admin/resources/views/admin/wallet/address_list.blade.php ENDPATH**/ ?>