<?php $__env->startSection('title', isset($title) ? $title : ''); ?>
<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- breadcrumb -->
    <div class="custom-breadcrumb">
        <div class="row">
            <div class="col-12">
                <ul>
                    <li><?php echo e(__('Currency Management')); ?></li>
                    <li class="active-item"><?php echo e($title); ?></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- /breadcrumb -->

    <!-- User Management -->
    <div class="user-management">
        <div class="row">
            <div class="col-12">
                <div class="profile-info-form">
                    <div class="card-body">
                        <form action="<?php echo e(route('adminCurrencyStore')); ?>" method="post">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-md-6 mt-20">
                                    <div class="form-group">
                                        <label for="firstname"><?php echo e(__('Currency Name')); ?></label>
                                        <input type="text" name="name" class="form-control" id="firstname" placeholder="<?php echo e(__('Currency name')); ?>"
                                               <?php if(isset($item)): ?> value="<?php echo e($item->name); ?>" <?php else: ?> value="<?php echo e(old('name')); ?>" <?php endif; ?>>
                                        <span class="text-danger"><strong><?php echo e($errors->first('name')); ?></strong></span>
                                    </div>
                                </div>
                                <div class="col-md-6 mt-20">
                                    <div class="form-group">
                                        <label for="lastname"><?php echo e(__('Currency Code')); ?></label>
                                        <div class="customSelect ">
                                            <select name="code" class="selectpicker" data-width="100%" data-live-search="true" title="<?php echo e(__('Choose one currency code')); ?>">
                                                <?php $__currentLoopData = fiat_currency_array(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($val['code']); ?>"> <?php echo e($val['name'].'('.$val['code'].' ,'. $val['symbol'].')'); ?> </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>

                                        <span class="text-danger"><strong><?php echo e($errors->first('code')); ?></strong></span>
                                    </div>
                                </div>
                                <div class="col-md-6 mt-20">
                                    <div class="form-group">
                                        <label for="email"><?php echo e(__('Currency Symbol')); ?></label>
                                        <input type="text" name="symbol" class="form-control" id="email" placeholder="<?php echo e(__('Currency symbol')); ?>"
                                               <?php if(isset($item)): ?> value="<?php echo e($item->symbol); ?>" <?php else: ?> value="<?php echo e(old('symbol')); ?>" <?php endif; ?>>
                                        <span class="text-danger"><strong><?php echo e($errors->first('symbol')); ?></strong></span>
                                    </div>
                                </div>
                                <div class="col-md-6 mt-20">
                                    <label for="bank_address"><?php echo e(__('Rate ( USD )')); ?></label>
                                    <div class="input-group mb-3 w-85 ">
                                        <input type="text" class="form-control" id="bank_address" name="rate"  placeholder="<?php echo e(__('Rate')); ?>"
                                               <?php if(isset($item)): ?> value="<?php echo e($item->rate); ?>" <?php else: ?> value="<?php echo e(old('rate')); ?>" <?php endif; ?>>
                                        <div class="input-group-append">
                                            <span class="input-group-text px-4"><span class="currency text-warning">USD</span></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 mt-20">
                                    <div class="form-group">
                                        <label class="switch" style="width: 150px;height: 42px;">
                                            <input <?php echo e(isset($item) && $item->status ? 'checked' : ''); ?> type="checkbox" name="status">
                                            <span class="slider round"></span>
                                        </label>
                                    </div>
                                </div>
                                <?php if(isset($item)): ?>
                                    <input type="hidden" name="id" value="<?php echo e($item->id); ?>">
                                <?php endif; ?>
                                <div class="col-md-12">
                                    <?php if(isset($item)): ?>
                                        <input type="hidden" name="edit_id" value="<?php echo e($item->id); ?>">
                                    <?php endif; ?>
                                    <button class="button-primary theme-btn"><?php if(isset($item)): ?> <?php echo e(__('Update')); ?> <?php else: ?> <?php echo e(__('Save')); ?> <?php endif; ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /User Management -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
         $('select[name="code"]').selectpicker('val', '<?php if(isset($item)): ?><?php echo e($item->code); ?><?php endif; ?>');
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master',['menu'=>'setting', 'sub_menu'=>'currency_list'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/tradexpro-admin/resources/views/admin/currency/addEdit.blade.php ENDPATH**/ ?>