<?php $__env->startSection('title', isset($title) ? $title : ''); ?>
<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- breadcrumb -->
    <div class="custom-breadcrumb">
        <div class="row">
            <div class="col-12">
                <ul>
                    <li><?php echo e(__('Transaction')); ?></li>
                    <li class="active-item"><?php echo e(__('All History')); ?></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- /breadcrumb -->

    <!-- User Management -->
    <div class="user-management pt-4">
        <div class="row no-gutters">
            <div class="col-12 col-lg-2">
                <ul class="nav user-management-nav profile-nav mb-3" id="pills-tab" role="tablist">
                    <li>
                        <a class=" active  nav-link " data-id="profile" data-toggle="pill" role="tab" data-controls="profile" aria-selected="true" href="#profile">
                            <img src="<?php echo e(asset('assets/admin/images/sidebar-icons/wallet.svg')); ?>" class="img-fluid" alt="">
                            <span><?php echo e(__('Deposit History')); ?></span>
                        </a>
                    </li>
                    <li>
                        <a class=" <?php if(isset($tab) && $tab=='edit_profile'): ?> active <?php endif; ?> nav-link  " data-id="edit_profile" data-toggle="pill" role="tab" data-controls="edit_profile" aria-selected="true" href="#edit_profile">
                            <img src="<?php echo e(asset('assets/admin/images/sidebar-icons/coin.svg')); ?>" class="img-fluid" alt="">
                            <span><?php echo e(__('Withdrawal History')); ?></span>
                        </a>
                    </li>
                </ul>
            </div>
            <div class="col-12 col-lg-10">
                <div class="tab-content tab-pt-n" id="tabContent">
                    <div class="tab-pane fade show active " id="profile" role="tabpanel" aria-labelledby="general-setting-tab">
                        <div class="table-area">
                            <div class="table-responsive">
                                <div class="">
                                    <form id="deposit_form" class="row" action="<?php echo e(route('adminTransactionHistoryExport')); ?>" method="get">
                                        <?php echo csrf_field(); ?>
                                        <div class="col-3 form-group">
                                            <label for="#"><?php echo e(__('From Date')); ?></label>
                                            <input type="hidden" name="type" value="deposit" />
                                            <input type="date" name="from_date" class="form-control" />
                                        </div>
                                        <div class="col-3 form-group">
                                            <label for="#"><?php echo e(__('To Date')); ?></label>
                                            <input type="date" name="to_date" class="form-control" />
                                        </div>
                                        <div class="col-3 form-group">
                                            <label for="#"><?php echo e(__('Export')); ?></label>
                                            <select name="export_to" class="selectpicker" data-width="100%" data-style="form-control" title="<?php echo e(__('Select a file type')); ?>">
                                                <option value=".csv">CSV</option>
                                                <option value=".xlsx">XLSX</option>
                                            </select>
                                        </div>
                                        <div class="col-3 form-group">
                                            <label for="#">&nbsp;</label>
                                            <input class="form-control btn btn-primary" style="background-color:#1d2124" type="submit" value="<?php echo e(__("Export")); ?>" />
                                        </div>
                                    </form>
                                </div>
                                <table id="deposit_table" class="table table-borderless custom-table display text-center"
                                        width="100%">
                                    <thead>
                                    <tr>
                                        <th class="all"><?php echo e(__('Type')); ?></th>
                                        <th class="all"><?php echo e(__('Sender')); ?></th>
                                        <th class="all"><?php echo e(__('Coin Type')); ?></th>
                                        <th><?php echo e(__('Address')); ?></th>
                                        <th><?php echo e(__('Receiver')); ?></th>
                                        <th><?php echo e(__('Amount')); ?></th>
                                        <th><?php echo e(__('Fees')); ?></th>
                                        <th><?php echo e(__('Transaction Id')); ?></th>
                                        <th><?php echo e(__('Status')); ?></th>
                                        <th><?php echo e(__('Created Date')); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>

                        </div>
                    </div>
                    <div class="tab-pane fade <?php if(isset($tab) && $tab=='edit_profile'): ?>show active <?php endif; ?>" id="edit_profile" role="tabpanel" aria-labelledby="apisetting-tab">
                        <div class="table-area">
                            <div class="table-responsive">
                                <div class="">
                                    <form id="withdrawal_form" class="row" action="<?php echo e(route('adminTransactionHistoryExport')); ?>" method="get">
                                        <?php echo csrf_field(); ?>
                                        <div class="col-3 form-group">
                                            <label for="#"><?php echo e(__('From Date')); ?></label>
                                            <input type="hidden" name="type" value="withdrawal" />
                                            <input type="date" name="from_date" class="form-control" />
                                        </div>
                                        <div class="col-3 form-group">
                                            <label for="#"><?php echo e(__('To Date')); ?></label>
                                            <input type="date" name="to_date" class="form-control" />
                                        </div>
                                        <div class="col-3 form-group">
                                            <label for="#"><?php echo e(__('Export')); ?></label>
                                            <select name="export_to" class="selectpicker" data-style="form-control" data-width="100%" title="<?php echo e(__('Select a file type')); ?>">
                                                <option value=".csv">CSV</option>
                                                <option value=".xlsx">XLSX</option>
                                            </select>
                                        </div>
                                        <div class="col-3 form-group">
                                            <label for="#">&nbsp;</label>
                                            <input class="form-control btn btn-primary" style="background-color:#1d2124" type="submit" value="<?php echo e(__("Export")); ?>" />
                                        </div>
                                    </form>
                                </div>
                                <table id="withdrawal_table" class="table table-borderless custom-table display text-center"
                                        width="100%">
                                    <thead>
                                    <tr>
                                        <th class="all"><?php echo e(__('Type')); ?></th>
                                        <th class="all"><?php echo e(__('Sender')); ?></th>
                                        <th class="all"><?php echo e(__('Coin type')); ?></th>
                                        <th><?php echo e(__('Address')); ?></th>
                                        <th><?php echo e(__('Receiver')); ?></th>
                                        <th><?php echo e(__('Amount')); ?></th>
                                        <th><?php echo e(__('Fees')); ?></th>
                                        <th><?php echo e(__('Transaction Id')); ?></th>
                                        <th><?php echo e(__('Status')); ?></th>
                                        <th><?php echo e(__('Created Date')); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /User Management -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        (function($) {
            "use strict";

            $('#deposit_table').DataTable({
                processing: true,
                serverSide: true,
                pageLength: 25,
                responsive: true,
                ajax: '<?php echo e(route('adminTransactionHistory')); ?>',
                order: [9, 'desc'],
                autoWidth: false,
                language: {
                    paginate: {
                        next: 'Next &#8250;',
                        previous: '&#8249; Previous'
                    }
                },
                columns: [
                    {"data": "address_type"},
                    {"data": "sender"},
                    {"data": "coin_type"},
                    {"data": "address"},
                    {"data": "receiver"},
                    {"data": "amount"},
                    {"data": "fees"},
                    {"data": "transaction_id"},
                    {"data": "status"},
                    {"data": "created_at"}
                ]
            });

            $('#withdrawal_table').DataTable({
                processing: true,
                serverSide: true,
                pageLength: 25,
                responsive: true,
                ajax: '<?php echo e(route('adminWithdrawalHistory')); ?>',
                order: [9, 'desc'],
                autoWidth: false,
                language: {
                    paginate: {
                        next: 'Next &#8250;',
                        previous: '&#8249; Previous'
                    }
                },
                columns: [
                    {"data": "address_type"},
                    {"data": "sender"},
                    {"data": "coin_type"},
                    {"data": "address"},
                    {"data": "receiver"},
                    {"data": "amount"},
                    {"data": "fees"},
                    {"data": "transaction_hash"},
                    {"data": "status"},
                    {"data": "created_at"}
                ]
            });
        })(jQuery)
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master',['menu'=>'transaction', 'sub_menu'=>'transaction_all'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/tradexpro-admin/resources/views/admin/transaction/all-transaction.blade.php ENDPATH**/ ?>