<?php $__env->startSection('title', isset($title) ? $title : __('Admin Login')); ?>

<?php $__env->startSection('content'); ?>
    <div class="user-content-wrapper" style="background-image: <?php if(!empty(settings('login_logo'))): ?>  url('<?php echo e(asset(path_image().settings()['login_logo'])); ?>') <?php else: ?> url('<?php echo e(asset('assets/user/images/user-content-wrapper-bg.jpg')); ?>') <?php endif; ?>">
        <div class="user-content-inner-wrap">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="user-form">
                        <div class="user-form-inner">
                            <div class="form-top">
                                <h2><?php echo e(__('Sign In')); ?></h2>
                                <p><?php echo e(__('Please sign in to your account')); ?></p>
                            </div>
                            <?php echo e(Form::open(['route' => 'loginProcess', 'files' => true, 'id'=>'submit-form'] )); ?>

                            <div class="form-group">
                                <input type="email" value="<?php echo e(old('email')); ?>" id="email" name="email"
                                        class="form-control" placeholder="<?php echo e(__('Your email')); ?>">
                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="invalid-feedback"><?php echo e($message); ?> </p>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group">
                                <input type="password" name="password" id="password"
                                        class="form-control form-control-password look-pass-a"
                                        placeholder="<?php echo e(__('Your password')); ?>">
                                <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="invalid-feedback"><?php echo e($message); ?> </p>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <span class="eye"><i class="fa fa-eye-slash toggle-password"
                                                        onclick="showHidePassword('old_password')"></i></span>
                            </div>
                            <?php if(settings('select_captcha_type') == CAPTCHA_TYPE_RECAPTCHA): ?>
                                <div class="form-group">
                                    <label></label>
                                    <?php echo app('captcha')->display(); ?>

                                    <?php $__errorArgs = ['g-recaptcha-response'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <p class="invalid-feedback"><?php echo e($message); ?> </p>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            <?php endif; ?>
                            
                            <?php if(settings('select_captcha_type') == CAPTCHA_TYPE_GEETESTCAPTCHA): ?>
                                <div id="captcha"></div>
                                <input id="lot_number" type="hidden" name="lot_number" value="">
                                <input id="captcha_output" type="hidden" name="captcha_output" value="">
                                <input id="pass_token" type="hidden" name="pass_token" value="">
                                <input id="gen_time" type="hidden" name="gen_time" value="">
                            <?php endif; ?>

                            <div class="d-flex justify-content-between rememberme align-items-center mb-4">
                                <div class="text-right"><a class="text-theme forgot-password" href="<?php echo e(route('forgotPassword')); ?>"><?php echo e(__('Forgot Password?')); ?></a>
                                </div>
                            </div>
                            <?php if(settings('select_captcha_type') == CAPTCHA_TYPE_GEETESTCAPTCHA): ?>
                                <button type="button" class="btn btn-primary nimmu-user-sibmit-button" id="submit-login"><?php echo e(__('Sign In')); ?></button>
                            <?php else: ?>
                                <button type="submit" class="btn btn-primary nimmu-user-sibmit-button"><?php echo e(__('Sign In')); ?></button>
                            <?php endif; ?>
                            <?php echo e(Form::close()); ?>

                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="user-content-text text-center">
                        <h3><?php echo e(__('Welcome To')); ?> <?php echo e(settings('app_title')); ?></h3>
                        <a class="auth-logo" href="javascript:;">
                            <img src="<?php echo e(show_image(1,'logo')); ?>" class="img-fluid" alt="">
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        (function($) {
            "use strict";

            $(".toggle-password").on('click', function () {
                $(this).toggleClass("fa-eye-slash fa-eye");
            });

            $(".eye").on('click', function () {
                var $pwd = $(".look-pass-a");
                if ($pwd.attr('type') === 'password') {
                    $pwd.attr('type', 'text');
                } else {
                    $pwd.attr('type', 'password');
                }
            });
        })(jQuery)
    </script>


<script src="<?php echo e(asset('assets/common/toast/vanillatoasts.js')); ?>"></script>
<script src="<?php echo e(asset('assets/common/geetest-captcha/geetest.js')); ?>"></script>

<script>
    
    if('<?php echo e(settings('select_captcha_type') == CAPTCHA_TYPE_GEETESTCAPTCHA); ?>')
    {
        $('#submit-login').click( function(){
            
            var email = $('#email').val();
            var password = $('#password').val();

            if(email === '')
            {
                VanillaToasts.create({
                    text: 'Email field is required',
                    type: 'warning',
                    timeout: 10000

                });
            
            }
            if(password === '')
            {
                VanillaToasts.create({
                    text: 'Password field is required',
                    type: 'warning',
                    timeout: 10000

                });
            
            }

            if(email !== '' && password !== '') {
                initGeetest4(
                    {
                        captchaId: "<?php echo e(settings('GEETEST_CAPTCHA_ID')); ?>",
                        product: "bind",
                    },
                    function (captcha) {
                        // call appendTo to insert CAPTCHA into an element of the page, which can be customized by you
                        captcha.appendTo("#captcha");
                        captcha
                        
                        .onSuccess(function () {
                            var result = captcha.getValidate();

                            $('#lot_number').val(result.lot_number);
                            $('#captcha_output').val(result.captcha_output);
                            $('#pass_token').val(result.pass_token);
                            $('#gen_time').val(result.gen_time);

                            $('#submit-form').submit();
                        });
                        
                        captcha.showCaptcha(); //show the CAPTCHA

                        
                    }
                );
            }
            
        });
    }

</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('auth.master',['menu'=>'dashboard'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/tradexpro-admin/resources/views/auth/login.blade.php ENDPATH**/ ?>