<div class="header-bar">
    <div class="table-title">
        <h3><?php echo e(__('Email Setup')); ?></h3>
    </div>
</div>
<div class="profile-info-form">
    <form action="<?php echo e(route('adminSaveEmailSettings')); ?>" method="post"
          enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="row">
            <div class="col-lg-6 col-12  mt-20">
                <div class="form-group">
                    <label for="#"><?php echo e(__('Mail Driver')); ?></label>
                    <input class="form-control" type="text" name="mail_driver"
                           placeholder="<?php echo e(__('Driver')); ?>" value="<?php echo e($settings['mail_driver']); ?>">
                </div>
            </div>
            <div class="col-lg-6 col-12  mt-20">
                <div class="form-group">
                    <label for="#"><?php echo e(__('Email Host')); ?></label>
                    <input class="form-control" type="text" name="mail_host"
                           placeholder="<?php echo e(__('Host')); ?>" value="<?php echo e($settings['mail_host']); ?>">
                </div>
            </div>
            <div class="col-lg-6 col-12  mt-20">
                <div class="form-group">
                    <label for="#"><?php echo e(__('Email Port')); ?></label>
                    <input class="form-control" type="text" name="mail_port"
                           placeholder="<?php echo e(__('Port')); ?>" value="<?php echo e($settings['mail_port']); ?>">
                </div>
            </div>
            <div class="col-lg-6 col-12  mt-20">
                <div class="form-group">
                    <label for="#"><?php echo e(__('Email Username')); ?></label>
                    <?php if(env('APP_MODE') == 'demo'): ?>
                        <input class="form-control" value="<?php echo e('disablefordemo'); ?>">
                    <?php else: ?>
                    <input class="form-control" type="text" name="mail_username"
                           placeholder="<?php echo e(__('Username')); ?>"
                           value="<?php echo e($settings['mail_username'] ?? ''); ?>">
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-lg-6 col-12  mt-20">
                <div class="form-group">
                    <label for="#"><?php echo e(__('Email Password')); ?></label>
                    <?php if(env('APP_MODE') == 'demo'): ?>
                        <input class="form-control" value="<?php echo e('disablefordemo'); ?>">
                    <?php else: ?>
                    <input class="form-control" type="password" name="mail_password"
                           placeholder="<?php echo e(__('Password')); ?>"
                           value="<?php echo e($settings['mail_password']); ?>">
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-lg-6 col-12  mt-20">
                <div class="form-group">
                    <label for="#"><?php echo e(__('Mail Encryption')); ?></label>
                    <input class="form-control" type="text" name="mail_encryption"
                           placeholder="<?php echo e(__('Encryption')); ?>"
                           value="<?php echo e(isset($settings['mail_encryption']) ? $settings['mail_encryption'] : ''); ?>">
                </div>
            </div>
            <div class="col-lg-6 col-12  mt-20">
                <div class="form-group">
                    <label for="#"><?php echo e(__('Mail Form Address')); ?></label>
                    <input class="form-control" type="text" name="mail_from_address"
                           placeholder="<?php echo e(__('Mail from address')); ?>"
                           value="<?php echo e(isset($settings['mail_from_address']) ? $settings['mail_from_address'] : ''); ?>">
                </div>
            </div>
        </div>
        <div class="row mt-3">
            <div class="col-md-12">
                <div class="header-bar">
                    <div class="table-title">
                        <h3><?php echo e(__('This configuration is only for mailgun (optional)')); ?></h3>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 col-12  mt-20">
                <div class="form-group">
                    <label for="#"><?php echo e(__('Mailgun Domain')); ?></label>
                    <input class="form-control" type="text" name="MAILGUN_DOMAIN"
                           placeholder="<?php echo e(__('Mailgun domain name')); ?>" value="<?php echo e($settings['MAILGUN_DOMAIN'] ?? ''); ?>">
                </div>
            </div>
            <div class="col-lg-6 col-12  mt-20">
                <div class="form-group">
                    <label for="#"><?php echo e(__('Mailgun Secret')); ?></label>
                    <input class="form-control" type="text" name="MAILGUN_SECRET"
                           placeholder="<?php echo e(__('Mailgun private api key')); ?>" value="<?php echo e($settings['MAILGUN_SECRET'] ?? ''); ?>">
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-2 col-12 mt-20">
                <button type="submit" class="button-primary theme-btn"><?php echo e(__('Update')); ?></button>
            </div>
        </div>
    </form>
</div>

<div class="header-bar mt-5">
    <div class="table-title">
        <h3><?php echo e(__('Check Email Configuration')); ?></h3>
    </div>
</div>
<div class="profile-info-form mt-5">
    <form action="<?php echo e(route('testmailsend')); ?>" method="post">
        <?php echo csrf_field(); ?>
        <div class="row">
            <div class="col-lg-6 col-12  mt-20">
                <div class="form-group">
                    <label for="#"><?php echo e(__('Email Address')); ?></label>
                    <input type="email" class="form-control" name="email" required>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-2 col-12 mt-20">
                <button type="submit" class="button-primary theme-btn"><?php echo e(__('Send Test Mail')); ?></button>
            </div>
        </div>
    </form>
</div>

<?php /**PATH /var/www/html/tradexpro-admin/resources/views/admin/settings/setting/email.blade.php ENDPATH**/ ?>