<?php $__env->startSection('title', isset($title) ? $title : ''); ?>
<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- breadcrumb -->
    <div class="custom-breadcrumb">
        <div class="row">
            <div class="col-9">
                <ul>
                    <li><?php echo e(__('Token Deposit')); ?></li>
                    <li class="active-item"><?php echo e($title); ?></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- /breadcrumb -->

    <!-- User Management -->
    <div class="user-management">
        <div class="row">
            <div class="col-12">
                <div class="header-bar p-4">
                    <div class="table-title">
                        <h3><?php echo e($title); ?></h3>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-area">
                        <div>
                            <table id="table" class="table table-borderless custom-table display text-center" width="100%">
                                <thead>
                                <tr>
                                    <th scope="col"><?php echo e(__('Deposit Id')); ?></th>
                                    <th scope="col"><?php echo e(__('Amount')); ?></th>
                                    <th scope="col"><?php echo e(__('Base Coin Type')); ?></th>
                                    <th scope="col"><?php echo e(__('Token')); ?></th>
                                    <th scope="col"><?php echo e(__('From Address')); ?></th>
                                    <th scope="col"><?php echo e(__('To Address')); ?></th>
                                    <th scope="col"><?php echo e(__('Tx Hash')); ?></th>
                                    <th scope="col"><?php echo e(__('Status')); ?></th>
                                    <th scope="col"><?php echo e(__('Created At')); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /User Management -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        (function($) {
            "use strict";

            $('#table').DataTable({
                processing: true,
                serverSide: true,
                pageLength: 10,
                retrieve: true,
                bLengthChange: true,
                responsive: true,
                ajax: '<?php echo e(route('adminGasSendHistory')); ?>',
                order: [8, 'desc'],
                autoWidth: false,
                language: {
                    paginate: {
                        next: 'Next &#8250;',
                        previous: '&#8249; Previous'
                    }
                },
                columns: [
                    {"data": "deposit_id", "orderable": true},
                    {"data": "amount", "orderable": true},
                    {"data": "coin_type", "orderable": true},
                    {"data": "token", "orderable": false,'searchable': false},
                    {"data": "admin_address", "orderable": true},
                    {"data": "user_address", "orderable": true},
                    {"data": "transaction_hash", "orderable": false},
                    {"data": "status", "orderable": false},
                    {"data": "created_at", "orderable": true},
                ],
            });
        })(jQuery);
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master',['menu'=>'deposit', 'sub_menu'=>'token_gas'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/tradexpro-admin/resources/views/admin/transaction/deposit/gas_sent_history.blade.php ENDPATH**/ ?>