<div class="header-bar">
    <div class="table-title">
        <h3><?php echo e(__('Update cookie Settings')); ?></h3>
    </div>
</div>
<div class="profile-info-form">
    <form action="<?php echo e(route('adminCookieSettingsSave')); ?>" method="post"
          enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="row">
            <div class="col-lg-6 col-12 mt-20">
                <div class="form-group">
                    <label><?php echo e(__('Enable Cookie')); ?></label>
                    <div class="cp-select-area">
                        <select name="cookie_status" class="form-control">
                            <option <?php if(isset($settings['cookie_status']) && $settings['cookie_status'] == STATUS_REJECTED): ?> selected <?php endif; ?> value="<?php echo e(STATUS_REJECTED); ?>"><?php echo e(__("No")); ?></option>
                            <option <?php if(isset($settings['cookie_status']) && $settings['cookie_status'] == STATUS_ACTIVE): ?> selected <?php endif; ?> value="<?php echo e(STATUS_ACTIVE); ?>"><?php echo e(__("Yes")); ?></option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 col-12 mt-20">
                <div class="form-group">
                    <label
                        for="#"><?php echo e(__('Cookie Header Text')); ?> </label>
                    <input class="form-control " type="text"
                           name="cookie_header" placeholder=""
                           value="<?php echo e(isset($settings['cookie_header']) ? $settings['cookie_header'] : ''); ?>">
                </div>
            </div>
            <div class="col-lg-6 col-12 mt-20">
                <div class="form-group">
                    <label
                        for="#"><?php echo e(__('Cookie Button Text')); ?> </label>
                    <input class="form-control " type="text"
                           name="cookie_button_text" placeholder=""
                           value="<?php echo e(isset($settings['cookie_button_text']) ? $settings['cookie_button_text'] : ''); ?>">
                </div>
            </div>
            <div class="col-lg-6 col-12 mt-20">
                <div class="form-group">
                    <label for="#"><?php echo e(__('Cookie description')); ?> </label>
                    <textarea class="form-control" name="cookie_text" id="" rows="1"><?php echo e($settings['cookie_text'] ?? ''); ?></textarea>
                </div>
            </div>
            <div class="col-lg-6 col-12 mt-20">
                <div class="form-group">
                    <label><?php echo e(__('Select page for cookie')); ?></label>
                    <div class="cp-select-area">
                        <select name="cookie_page_key" class="form-control">
                            <?php if(isset($pages[0])): ?>
                                <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option <?php if(isset($settings['cookie_page_key']) && $settings['cookie_page_key'] == $page->key): ?> selected <?php endif; ?> value="<?php echo e($page->key); ?>"><?php echo e($page->title); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </select>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 mt-20">
                <div class="single-uplode">
                    <div class="uplode-catagory">
                        <span><?php echo e(__('Cookie Image')); ?></span>
                    </div>
                    <div class="form-group buy_coin_address_input ">
                        <div id="file-upload" class="section-p">
                            <input type="file" placeholder="0.00" name="cookie_image" value=""
                                   id="file" ref="file" class="dropify"
                                   <?php if(isset($settings['cookie_image']) && (!empty($settings['cookie_image']))): ?>  data-default-file="<?php echo e(asset(path_image().$settings['cookie_image'])); ?>" <?php endif; ?> />
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-2 col-12 mt-20">
                <button class="button-primary theme-btn"><?php echo e(__('Update')); ?></button>
            </div>
        </div>
    </form>
</div>
<?php /**PATH /var/www/html/tradexpro-admin/resources/views/admin/settings/feature/cookie_setting.blade.php ENDPATH**/ ?>