<div class="header-bar">
    <div class="table-title">
        <h3><?php echo e(__('Exchange Layout Settings')); ?></h3>
    </div>
</div>
<div class="profile-info-form">
    <form action="<?php echo e(route('adminExchangeLayoutSettings')); ?>" method="post" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="row">
            <div class="col-lg-4 col-12 mt-20">
                <div class="form-group">
                    <label><?php echo e(__('Choose Layout')); ?></label>
                    <div class="cp-select-area">
                        <select id="exchange_view" name="exchange_layout_view" class="form-control">
                            <?php $__currentLoopData = exchangeLayout(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key); ?>" <?php if(isset($settings['exchange_layout_view']) && $settings['exchange_layout_view'] == $key): ?> selected <?php endif; ?>><?php echo e($val); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
            </div>
            <div class="col-lg-1"></div>
            <div class="col-lg-7 col-12  mt-20">
                <div id="layout1" class="form-group <?php if(isset($settings['exchange_layout_view']) && $settings['exchange_layout_view'] == EXCHANGE_LAYOUT_ONE): ?> d-block <?php else: ?> d-none <?php endif; ?>">
                    <img class="exchange-layout-img" width="90%" src="<?php echo e(asset('assets/admin/images/exchange_layout/layout1.png')); ?>" alt="">
                </div>
                <div id="layout2" class="form-group <?php if(isset($settings['exchange_layout_view']) && $settings['exchange_layout_view'] == EXCHANGE_LAYOUT_TWO): ?> d-block <?php else: ?> d-none <?php endif; ?>">
                    <img class="exchange-layout-img" width="90%" src="<?php echo e(asset('assets/admin/images/exchange_layout/layout2.png')); ?>" alt="">
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-2 col-12 mt-20">
                <button class="button-primary theme-btn"><?php echo e(__('Update')); ?></button>
            </div>
        </div>
    </form>
</div>

<?php /**PATH /var/www/html/tradexpro-admin/resources/views/admin/settings/setting/include/exchange_layout.blade.php ENDPATH**/ ?>