<?php

namespace App\Http\Controllers\Api\User;

use App\Model\UserBank;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Http\Services\FiatWithdrawalService;
use App\Http\Requests\Api\User\FiatWithdrawalRequest;
use App\Http\Requests\Api\User\FiatWalletWithdrawalRequest;

class FiatWithdrawalController extends Controller
{
    private $service;
    function __construct()
    {
        $this->service = new FiatWithdrawalService();
    }
    // fiat withdrawal data
    public function fiatWithdrawal()
    {
        $response = $this->service->getFiatWithdrawalData(Auth::id());

        return response()->json($response);
    }

    // fiat withdrawal rate
    public function getFiatWithdrawalRate(FiatWithdrawalRequest $request)
    {
        $response = $this->service->getFiatWithdrawalRateData($request,Auth::id());

        return response()->json($response);
    }
    // fiat withdrawal process
    public function fiatWithdrawalProcess(FiatWithdrawalRequest $request)
    {
        $response = $this->service->fiatWithdrawalProcess($request,Auth::id());

        return response()->json($response);
    }
    // fiat withdrawal list
    public function fiatWithdrawHistory(Request $request){
        try{
            $response = $this->service->getWithdrawalHistory(Auth::id(), $request->per_page);
            return response()->json($response);
        }catch (\Exception $e){
            return response()->json(['success' => false,'message' => __('Something went wrong')]);
        }
    }

    public function getWalletCurrencyWithdrawalPage(Request $request){
        $data['my_bank'] = UserBank::where(['user_id' => getUserId(), 'status' => STATUS_ACTIVE])->get();
        return response()->json(responseData(true,__("Withdrawal data get successfully"), $data));
    }

    public function fiatWalletWithdrawalProcess(FiatWalletWithdrawalRequest $request)
    {
        return response()->json(
            $this->service->fiatWalletWithdrawalProcess($request,Auth::id())
        );
    }
   
    public function fiatWalletWithdrawalHistory(Request $request)
    {
        return response()->json(
            $this->service->fiatWalletWithdrawalHistory($request)
        );
    }
}
